/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class AttributeMarshallers {
    public static final AttributeMarshaller DISCOVERY_GROUP_MARSHALLER = new AttributeInsideElementMarshaller("discovery-group-ref", "discovery-group-name");
    public static final AttributeMarshaller NOOP_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        }

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        }
    };
    public static final AttributeMarshaller CONNECTORS_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.hasDefined(Element.CONNECTOR.getLocalName())) {
                writer.writeStartElement(Element.CONNECTORS.getLocalName());
                for (Property connProp : resourceModel.get(Element.CONNECTOR.getLocalName()).asPropertyList()) {
                    writer.writeStartElement(Element.CONNECTOR_REF.getLocalName());
                    writer.writeAttribute(Attribute.CONNECTOR_NAME.getLocalName(), connProp.getName());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    };
    public static final AttributeMarshaller SELECTOR_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.hasDefined(attribute.getName())) {
                String selector = resourceModel.get(attribute.getName()).asString();
                writer.writeEmptyElement(Element.SELECTOR.getLocalName());
                writer.writeAttribute(Attribute.STRING.getLocalName(), selector);
            }
        }
    };
    public static final AttributeMarshaller JNDI_CONTEXT_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.hasDefined(attribute.getName())) {
                ModelNode context = resourceModel.get(attribute.getName());
                writer.writeStartElement(attribute.getXmlName());
                for (Property property : context.asPropertyList()) {
                    writer.writeStartElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute(Attribute.KEY.getLocalName(), property.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), property.getValue().asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    };
    public static final AttributeMarshaller JNDI_RESOURCE_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.hasDefined(attribute.getName())) {
                String name = resourceModel.get(attribute.getName()).asString();
                writer.writeEmptyElement(attribute.getXmlName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            }
        }
    };
    public static final AttributeMarshaller INTERCEPTOR_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                writer.writeStartElement(attribute.getXmlName());
                for (ModelNode child : list) {
                    writer.writeStartElement(Element.CLASS_NAME.getLocalName());
                    writer.writeCharacters(child.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
    };

    public static final class JndiEntriesAttributeMarshaller
    extends AttributeMarshaller {
        private final boolean forDestination;

        public JndiEntriesAttributeMarshaller(boolean forDestination) {
            this.forDestination = forDestination;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                if (!this.forDestination) {
                    writer.writeStartElement(attribute.getXmlName());
                }
                for (ModelNode child : list) {
                    writer.writeEmptyElement(Element.ENTRY.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), child.asString());
                }
                if (!this.forDestination) {
                    writer.writeEndElement();
                }
            }
        }
    }

    public static final class WrappedListAttributeMarshaller
    extends AttributeMarshaller {
        private final String wrappingElementName;

        public WrappedListAttributeMarshaller(String wrappingElementName) {
            this.wrappingElementName = wrappingElementName;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                if (this.wrappingElementName != null) {
                    writer.writeStartElement(this.wrappingElementName);
                }
                for (ModelNode child : list) {
                    writer.writeStartElement(attribute.getXmlName());
                    writer.writeCharacters(child.asString());
                    writer.writeEndElement();
                }
                if (this.wrappingElementName != null) {
                    writer.writeEndElement();
                }
            }
        }
    }

    private static final class AttributeInsideElementMarshaller
    extends AttributeMarshaller {
        private final String elementName;
        private final String attributeName;

        public AttributeInsideElementMarshaller(String elementName, String attributeName) {
            this.elementName = elementName;
            this.attributeName = attributeName;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel)) {
                writer.writeStartElement(this.elementName);
                writer.writeAttribute(this.attributeName, resourceModel.get(this.attributeName).asString());
                writer.writeEndElement();
            }
        }
    }
}

