/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.util.Map;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;

@Scope(value=Scopes.GLOBAL)
public class EncoderRegistryImpl
implements EncoderRegistry {
    private final Map<Class<? extends Encoder>, Encoder> encoderMap = CollectionFactory.makeConcurrentMap((int)10);
    private final Map<Class<? extends Wrapper>, Wrapper> wrapperMap = CollectionFactory.makeConcurrentMap((int)2);
    private final Map<Short, Class<? extends Encoder>> encoderById = CollectionFactory.makeConcurrentMap((int)10);
    private final Map<Byte, Class<? extends Wrapper>> wrapperById = CollectionFactory.makeConcurrentMap((int)2);

    @Override
    public void registerEncoder(Encoder encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("Encoder cannot be null");
        }
        short id = encoder.id();
        if (this.encoderById.containsKey(id)) {
            throw new IllegalArgumentException("Cannot register encoder: duplicate id " + id);
        }
        this.encoderById.put(id, encoder.getClass());
        this.encoderMap.put(encoder.getClass(), encoder);
    }

    @Override
    public void registerWrapper(Wrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("Wrapper cannot be null");
        }
        byte id = wrapper.id();
        if (this.wrapperById.containsKey(id)) {
            throw new EncodingException("Cannot register wrapper: duplicate id " + id);
        }
        this.wrapperById.put(id, wrapper.getClass());
        this.wrapperMap.put(wrapper.getClass(), wrapper);
    }

    @Override
    public Encoder getEncoder(Class<? extends Encoder> clazz, Short encoderId) {
        Class<? extends Encoder> encoderClass;
        if (clazz == null && encoderId == null) {
            throw new IllegalArgumentException("Encoder class or identifier must be provided!");
        }
        Class<? extends Encoder> clazz2 = encoderClass = clazz == null ? this.encoderById.get(encoderId) : clazz;
        if (encoderClass == null) {
            throw new EncodingException("Encoder not found for id " + encoderId);
        }
        Encoder encoder = this.encoderMap.get(encoderClass);
        if (encoder == null) {
            throw new EncodingException("Encoder not found: " + clazz);
        }
        return encoder;
    }

    @Override
    public Wrapper getWrapper(Class<? extends Wrapper> clazz, Byte wrapperId) {
        Class<? extends Wrapper> wrapperClass;
        if (clazz == null && wrapperId == null) {
            throw new IllegalArgumentException("Wrapper class or identifier must be provided!");
        }
        Class<? extends Wrapper> clazz2 = wrapperClass = clazz == null ? this.wrapperById.get(wrapperId) : clazz;
        if (wrapperClass == null) {
            throw new EncodingException("Wrapper not found id " + wrapperId);
        }
        Wrapper wrapper = this.wrapperMap.get(wrapperClass);
        if (wrapper == null) {
            throw new EncodingException("Wrapper not found: " + clazz);
        }
        return wrapper;
    }
}

