/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.constExpr;

import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import java.math.BigInteger;

public class Terminal
extends Expression {
    protected Terminal(String representation, Character charValue, boolean isWide) {
        this.rep(representation);
        this.value(charValue);
        if (isWide) {
            this.type("wchar");
        } else {
            this.type("char");
        }
    }

    protected Terminal(String representation, Boolean booleanValue) {
        this.rep(representation);
        this.value(booleanValue);
    }

    protected Terminal(String representation, BigInteger bigIntegerValue) {
        this.rep(representation);
        this.value(bigIntegerValue);
    }

    protected Terminal(String representation, Long longValue) {
        long lv = longValue;
        this.rep(representation);
        if (lv > Integer.MAX_VALUE || lv < Integer.MIN_VALUE) {
            this.value(longValue);
        } else {
            this.value(new Integer(longValue.intValue()));
        }
    }

    protected Terminal(String representation, Double doubleValue) {
        this.rep(representation);
        this.value(doubleValue);
    }

    protected Terminal(String stringValue, boolean isWide) {
        this.rep(stringValue);
        this.value(stringValue);
        if (isWide) {
            this.type("wstring");
        } else {
            this.type("string");
        }
    }

    protected Terminal(ConstEntry constReference) {
        this.rep(constReference.fullName());
        this.value(constReference);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        if (this.value() instanceof ConstEntry) {
            return ((ConstEntry)this.value()).value().evaluate();
        }
        return this.value();
    }
}

