/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.ejb.infinispan.BasicSessionIDExternalizer;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.marshalling.Externalizer;

public class InfinispanBeanEntryExternalizer
implements Externalizer<InfinispanBeanEntry<SessionID>> {
    private final Externalizer<SessionID> externalizer = new BasicSessionIDExternalizer();

    public void writeObject(ObjectOutput output, InfinispanBeanEntry<SessionID> entry) throws IOException {
        output.writeUTF(entry.getBeanName());
        this.externalizer.writeObject(output, (Object)entry.getGroupId());
        Date lastAccessedTime = entry.getLastAccessedTime();
        output.writeLong(lastAccessedTime != null ? lastAccessedTime.getTime() : 0L);
    }

    public InfinispanBeanEntry<SessionID> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        InfinispanBeanEntry<Object> entry = new InfinispanBeanEntry<Object>(input.readUTF(), this.externalizer.readObject(input));
        long time = input.readLong();
        if (time > 0L) {
            entry.setLastAccessedTime(new Date(time));
        }
        return entry;
    }

    public Class<InfinispanBeanEntry<SessionID>> getTargetClass() {
        Class<InfinispanBeanEntry> targetClass = InfinispanBeanEntry.class;
        return targetClass;
    }
}

