/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.election.NamePreference;
import org.wildfly.clustering.singleton.election.Preference;
import org.wildfly.clustering.singleton.election.PreferredSingletonElectionPolicy;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.ElectionPolicyServiceNameProvider;
import org.wildfly.extension.clustering.singleton.election.OutboundSocketBindingPreference;

public abstract class ElectionPolicyBuilder
extends ElectionPolicyServiceNameProvider
implements ResourceServiceBuilder<SingletonElectionPolicy>,
Value<SingletonElectionPolicy> {
    private final List<Preference> preferences = new CopyOnWriteArrayList<Preference>();
    private final List<Dependency> dependencies = new CopyOnWriteArrayList<Dependency>();

    protected ElectionPolicyBuilder(PathAddress policyAddress) {
        super(policyAddress);
    }

    public ServiceBuilder<SingletonElectionPolicy> build(ServiceTarget target) {
        final List<Preference> preferences = this.preferences;
        Value<SingletonElectionPolicy> value = new Value<SingletonElectionPolicy>(){

            public SingletonElectionPolicy getValue() {
                SingletonElectionPolicy policy = (SingletonElectionPolicy)ElectionPolicyBuilder.this.getValue();
                return preferences.isEmpty() ? policy : new PreferredSingletonElectionPolicy(policy, preferences);
            }
        };
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)value)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        for (Dependency dependency : this.dependencies) {
            dependency.register(builder);
        }
        return builder;
    }

    public Builder<SingletonElectionPolicy> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.preferences.clear();
        this.dependencies.clear();
        for (String bindingName : ModelNodes.asStringList((ModelNode)ElectionPolicyResourceDefinition.Attribute.SOCKET_BINDING_PREFERENCES.getDefinition().resolveModelAttribute(context, model))) {
            InjectedValueDependency binding = new InjectedValueDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, bindingName), OutboundSocketBinding.class);
            this.preferences.add(new OutboundSocketBindingPreference((Value<OutboundSocketBinding>)binding));
            this.dependencies.add((Dependency)binding);
        }
        for (String nodeName : ModelNodes.asStringList((ModelNode)ElectionPolicyResourceDefinition.Attribute.NAME_PREFERENCES.getDefinition().resolveModelAttribute(context, model))) {
            this.preferences.add((Preference)new NamePreference(nodeName));
        }
        return this;
    }
}

