/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment.injection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import org.wildfly.extension.messaging.activemq.deployment.injection.JMSInfo;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public abstract class AbstractJMSContext
implements Serializable {
    private final Map<String, JMSContext> contexts = new HashMap<String, JMSContext>();

    synchronized JMSContext getContext(String injectionPointId, JMSInfo info, ConnectionFactory connectionFactory) {
        JMSContext context = this.contexts.get(injectionPointId);
        if (context == null) {
            context = this.createContext(info, connectionFactory);
            this.contexts.put(injectionPointId, context);
        }
        return context;
    }

    private JMSContext createContext(JMSInfo info, ConnectionFactory connectionFactory) {
        JMSContext context;
        MessagingLogger.ROOT_LOGGER.debugf("Create JMSContext from %s - %s", info, connectionFactory);
        int sessionMode = info.getSessionMode();
        String userName = info.getUserName();
        if (userName == null) {
            context = connectionFactory.createContext(sessionMode);
        } else {
            String password = info.getPassword();
            context = connectionFactory.createContext(userName, password, sessionMode);
        }
        return context;
    }

    @PreDestroy
    void cleanUp() {
        MessagingLogger.ROOT_LOGGER.debugf("Clean up JMSContext created from %s", this);
        this.contexts.values().forEach(JMSContext::close);
        this.contexts.clear();
    }
}

