/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReattachSessionResponseMessage
extends PacketImpl {
    private int lastConfirmedCommandID;
    private boolean reattached;

    public ReattachSessionResponseMessage(int lastConfirmedCommandID, boolean reattached) {
        super((byte)33);
        this.lastConfirmedCommandID = lastConfirmedCommandID;
        this.reattached = reattached;
    }

    public ReattachSessionResponseMessage() {
        super((byte)33);
    }

    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID;
    }

    public boolean isReattached() {
        return this.reattached;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.lastConfirmedCommandID);
        buffer.writeBoolean(this.reattached);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.lastConfirmedCommandID = buffer.readInt();
        this.reattached = buffer.readBoolean();
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.lastConfirmedCommandID;
        result = 31 * result + (this.reattached ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReattachSessionResponseMessage)) {
            return false;
        }
        ReattachSessionResponseMessage other = (ReattachSessionResponseMessage)obj;
        if (this.lastConfirmedCommandID != other.lastConfirmedCommandID) {
            return false;
        }
        return this.reattached == other.reattached;
    }
}

