/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

public class Schema {
    final int major;
    final int minor;

    public Schema(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean since(int major, int minor) {
        return this.major > major || this.major == major && this.minor >= minor;
    }

    public static Schema fromNamespaceURI(String namespaceURI) {
        int major = 999;
        int minor = 999;
        if (namespaceURI.startsWith("uri:") || namespaceURI.startsWith("urn:")) {
            String version = namespaceURI.substring(namespaceURI.lastIndexOf(58) + 1);
            String[] split = version.split("\\.");
            try {
                major = Integer.parseInt(split[0]);
                minor = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Schema(major, minor);
    }
}

