/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class NotificationInterceptor
extends DDAsyncInterceptor {
    private CacheNotifier notifier;
    private final InvocationSuccessAction commitSuccessAction = new InvocationSuccessAction(){

        @Override
        public void accept(InvocationContext rCtx, VisitableCommand rCommand, Object rv) throws Throwable {
            NotificationInterceptor.this.notifier.notifyTransactionCompleted(((TxInvocationContext)rCtx).getGlobalTransaction(), true, rCtx);
        }
    };
    private final InvocationSuccessAction rollbackSuccessAction = new InvocationSuccessAction(){

        @Override
        public void accept(InvocationContext rCtx, VisitableCommand rCommand, Object rv) throws Throwable {
            NotificationInterceptor.this.notifier.notifyTransactionCompleted(((TxInvocationContext)rCtx).getGlobalTransaction(), false, rCtx);
        }
    };

    @Inject
    public void injectDependencies(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.commitSuccessAction);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, this.commitSuccessAction);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, this.rollbackSuccessAction);
    }
}

