/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.Http20RequestHandler;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;

public class Http11RequestHandler
extends Http20RequestHandler {
    public Http11RequestHandler(RestServerConfiguration configuration, EmbeddedCacheManager embeddedCacheManager) {
        super(configuration, embeddedCacheManager);
    }

    public Http11RequestHandler(RestServerConfiguration configuration, EmbeddedCacheManager embeddedCacheManager, Authenticator authenticator) {
        super(configuration, embeddedCacheManager, authenticator);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        super.channelRead0(ctx, request);
    }

    @Override
    protected void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        ctx.executor().execute(() -> {
            this.restAccessLoggingHandler.log(ctx, request, response);
            if (HttpUtil.isKeepAlive((HttpMessage)response)) {
                ctx.writeAndFlush((Object)response);
            } else {
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        });
    }
}

