/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocator;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocatorBuilder
implements Builder<RouteLocator>,
Value<RouteLocator>,
InfinispanRouteLocatorConfiguration {
    private final String deploymentName;
    private final InjectedValue<NodeFactory> factory = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();

    private static ServiceName getServiceName(String deploymentName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "web", "locator", deploymentName});
    }

    public static ServiceName getCacheServiceAlias(String deploymentName) {
        return InfinispanRouteLocatorBuilder.getServiceName(deploymentName).append(new String[]{"cache"});
    }

    public static ServiceName getNodeFactoryServiceAlias(String deploymentName) {
        return InfinispanRouteLocatorBuilder.getServiceName(deploymentName).append(new String[]{"nodes"});
    }

    public static ServiceName getRegistryServiceAlias(String deploymentName) {
        return InfinispanRouteLocatorBuilder.getServiceName(deploymentName).append(new String[]{"registry"});
    }

    public InfinispanRouteLocatorBuilder(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public ServiceName getServiceName() {
        return InfinispanRouteLocatorBuilder.getServiceName(this.deploymentName);
    }

    public ServiceBuilder<RouteLocator> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(InfinispanRouteLocatorBuilder.getNodeFactoryServiceAlias(this.deploymentName), NodeFactory.class, this.factory).addDependency(InfinispanRouteLocatorBuilder.getRegistryServiceAlias(this.deploymentName), Registry.class, this.registry).addDependency(InfinispanRouteLocatorBuilder.getCacheServiceAlias(this.deploymentName), Cache.class, this.cache).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RouteLocator getValue() {
        return new InfinispanRouteLocator(this);
    }

    @Override
    public Cache<String, ?> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public Registry<String, Void> getRegistry() {
        return (Registry)this.registry.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.factory.getValue();
    }
}

