/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

public class LexicalUtil {
    public static StringBuilder convertSpecialCharacters(StringBuilder inBuf) {
        int i = inBuf.indexOf("\\");
        if (i == -1) {
            return inBuf;
        }
        StringBuilder outBuf = new StringBuilder(inBuf.length());
        int followIndex = -1;
        while (i != -1) {
            outBuf.append(inBuf.subSequence(followIndex + 1, i));
            followIndex = i + 1;
            char c = inBuf.charAt(followIndex);
            switch (c) {
                case 'u': {
                    char unicodeChar = LexicalUtil.readUnicode(inBuf, followIndex + 1);
                    outBuf.append(unicodeChar);
                    followIndex += 4;
                    break;
                }
                case 'n': {
                    outBuf.append('\n');
                    break;
                }
                case 'r': {
                    outBuf.append('\r');
                    break;
                }
                case 't': {
                    outBuf.append('\t');
                    break;
                }
                case 'f': {
                    outBuf.append('\f');
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuf.append(c);
                    break;
                }
                default: {
                    outBuf.append('\\');
                    outBuf.append(c);
                }
            }
            i = inBuf.indexOf("\\", followIndex + 1);
        }
        outBuf.append(inBuf.subSequence(followIndex + 1, inBuf.length()));
        return outBuf;
    }

    private static char readUnicode(StringBuilder inBuf, int i) {
        int r = 0;
        for (int j = i; j < i + 4; ++j) {
            char atJ = inBuf.charAt(j);
            if (atJ >= '0' && atJ <= '9') {
                r = (r << 4) + atJ - 48;
                continue;
            }
            if (atJ >= 'A' && atJ <= 'F') {
                r = (r << 4) + atJ - 55;
                continue;
            }
            if (atJ < 'a' || atJ > 'f') continue;
            r = (r << 4) + atJ - 87;
        }
        return (char)r;
    }
}

