/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.session.SessionIdGenerator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;

public class SSOManagerBuilder
implements Builder<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch>>,
Service<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch>>,
LocalContextFactory<Void> {
    private final InjectedValue<SessionIdGenerator> generator = new InjectedValue();
    private final InjectedValue<SSOManagerFactory> factory = new InjectedValue();
    private final ServiceName factoryServiceName;
    private final ServiceName generatorServiceName;
    private volatile SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch> manager;

    public SSOManagerBuilder(ServiceName factoryServiceName, ServiceName generatorServiceName) {
        this.factoryServiceName = factoryServiceName;
        this.generatorServiceName = generatorServiceName;
    }

    public ServiceName getServiceName() {
        return this.factoryServiceName.append(new String[]{"manager"});
    }

    public ServiceBuilder<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch>> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)this).addDependency(this.factoryServiceName, SSOManagerFactory.class, this.factory).addDependency(this.generatorServiceName, SessionIdGenerator.class, this.generator);
    }

    public void start(StartContext context) throws StartException {
        SSOManagerFactory factory = (SSOManagerFactory)this.factory.getValue();
        this.manager = factory.createSSOManager((IdentifierFactory)new IdentifierFactoryAdapter((SessionIdGenerator)this.generator.getValue()), (LocalContextFactory)this);
        this.manager.start();
    }

    public void stop(StopContext context) {
        this.manager.stop();
        this.manager = null;
    }

    public SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch> getValue() {
        return this.manager;
    }

    public Void createLocalContext() {
        return null;
    }
}

