/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.handlers;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.picketlink.config.federation.handler.Handler;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.AlternativeAttributeValidationStepHandler;
import org.wildfly.extension.picketlink.common.model.validator.UniqueTypeValidationStepHandler;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerRemoveHandler;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;

public class HandlerAddHandler
extends AbstractAddStepHandler {
    static final HandlerAddHandler INSTANCE = new HandlerAddHandler();

    private HandlerAddHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AlternativeAttributeValidationStepHandler((AttributeDefinition[])new SimpleAttributeDefinition[]{HandlerResourceDefinition.CLASS_NAME, HandlerResourceDefinition.CODE}), OperationContext.Stage.MODEL);
        context.addStep((OperationStepHandler)new UniqueTypeValidationStepHandler(ModelElement.COMMON_HANDLER){

            @Override
            protected String getType(OperationContext context, ModelNode model) throws OperationFailedException {
                return HandlerResourceDefinition.getHandlerType(context, model);
            }
        }, OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : HandlerResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String providerAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        EntityProviderService providerService = EntityProviderService.getService(context, providerAlias);
        Handler handler = HandlerAddHandler.toHandlerConfig(context, model);
        providerService.addHandler(handler);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            HandlerRemoveHandler.INSTANCE.performRuntime(context, operation, resource.getModel());
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public static Handler toHandlerConfig(OperationContext context, ModelNode handler) throws OperationFailedException {
        Handler newHandler = new Handler();
        String typeName = HandlerResourceDefinition.getHandlerType(context, handler);
        newHandler.setClazz(typeName);
        return newHandler;
    }
}

