/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.factory;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.activemq.artemis.cli.ConfigurationException;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ServerDTO;
import org.apache.activemq.artemis.factory.BrokerFactoryHandler;
import org.apache.activemq.artemis.factory.BrokerHandler;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.FactoryFinder;

public class BrokerFactory {
    public static BrokerDTO createBrokerConfiguration(URI configURI) throws Exception {
        if (configURI.getScheme() == null) {
            throw new ConfigurationException("Invalid configuration URI, no scheme specified: " + configURI);
        }
        BrokerFactoryHandler factory = null;
        try {
            FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/activemq/artemis/broker/");
            factory = (BrokerFactoryHandler)finder.newInstance(configURI.getScheme());
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
        }
        return factory.createBroker(configURI);
    }

    public static BrokerDTO createBrokerConfiguration(String configuration) throws Exception {
        return BrokerFactory.createBrokerConfiguration(new URI(configuration));
    }

    static String fixupFileURI(String value) {
        if (value != null && value.startsWith("file:")) {
            value = value.substring("file:".length());
            value = new File(value).toURI().toString();
        }
        return value;
    }

    public static Broker createServer(ServerDTO brokerDTO, ActiveMQSecurityManager security) throws Exception {
        if (brokerDTO.configuration != null) {
            BrokerHandler handler;
            URI configURI = brokerDTO.getConfigurationURI();
            try {
                FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/activemq/artemis/broker/server/");
                handler = (BrokerHandler)finder.newInstance(configURI.getScheme());
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Invalid configuration URI, can't find configuration scheme: " + configURI.getScheme());
            }
            return handler.createServer(brokerDTO, security);
        }
        return null;
    }
}

