/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchLocalDateTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<LocalDateTime> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalDateBridge.FORMATTER).appendLiteral('T').append(ElasticsearchLocalTimeBridge.FORMATTER).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchLocalDateTimeBridge INSTANCE = new ElasticsearchLocalDateTimeBridge();

    private ElasticsearchLocalDateTimeBridge() {
        super(FORMATTER, LocalDateTime.class);
    }

    @Override
    LocalDateTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return LocalDateTime.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForLocalDateTime(e);
    }
}

