/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneScoreDocExternalizer
extends AbstractExternalizer<ScoreDoc> {
    public Set<Class<? extends ScoreDoc>> getTypeClasses() {
        return Collections.singleton(ScoreDoc.class);
    }

    public ScoreDoc readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return LuceneScoreDocExternalizer.readObjectStatic(input);
    }

    public void writeObject(ObjectOutput output, ScoreDoc sortField) throws IOException {
        LuceneScoreDocExternalizer.writeObjectStatic(output, sortField);
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_SCORE_DOC;
    }

    private static void writeObjectStatic(ObjectOutput output, ScoreDoc sortField) throws IOException {
        output.writeFloat(sortField.score);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)sortField.doc);
        output.writeInt(sortField.shardIndex);
    }

    private static ScoreDoc readObjectStatic(ObjectInput input) throws IOException, ClassNotFoundException {
        float score = input.readFloat();
        int doc = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        int shardId = input.readInt();
        return new ScoreDoc(doc, score, shardId);
    }
}

