/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.dmr.ModelNode;

public abstract class ProtocolServiceSubsystemAdd
extends AbstractAddStepHandler {
    private static final int DEFAULT_WORKER_THREADS = 160;

    protected String getServiceName(ModelNode config) {
        return config.hasDefined("name") ? config.get("name").asString() : null;
    }

    protected String getSocketBindingName(ModelNode config) {
        return config.hasDefined("socket-binding") ? config.get("socket-binding").asString() : null;
    }

    protected String getCacheContainerName(ModelNode config) {
        return config.hasDefined("cache-container") ? config.get("cache-container").asString() : null;
    }

    protected void configureProtocolServer(ProtocolServerConfigurationBuilder<?, ?> builder, ModelNode config) {
        if (config.hasDefined("name")) {
            builder.name(config.get("name").asString());
        }
        builder.workerThreads(config.hasDefined("worker-threads") ? config.get("worker-threads").asInt() : 160);
        if (config.hasDefined("idle-timeout")) {
            builder.idleTimeout(config.get("idle-timeout").asInt());
        }
        if (config.hasDefined("tcp-nodelay")) {
            builder.tcpNoDelay(config.get("tcp-nodelay").asBoolean());
        }
        if (config.hasDefined("send-buffer-size")) {
            builder.sendBufSize(config.get("send-buffer-size").asInt());
        }
        if (config.hasDefined("receive-buffer-size")) {
            builder.recvBufSize(config.get("receive-buffer-size").asInt());
        }
        if (config.hasDefined("ignored-caches")) {
            Set ignoredCaches = config.get("ignored-caches").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
            builder.ignoredCaches(ignoredCaches);
        }
    }
}

