/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.definition.impl;

import org.hibernate.search.elasticsearch.analyzer.definition.ElasticsearchAnalyzerDefinitionContext;
import org.hibernate.search.elasticsearch.analyzer.definition.ElasticsearchAnalyzerDefinitionWithTokenizerContext;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchAnalyzerDefinitionContextImpl
implements ElasticsearchAnalyzerDefinitionContext,
ElasticsearchAnalyzerDefinitionWithTokenizerContext,
ElasticsearchAnalysisDefinitionRegistryPopulator {
    protected static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final String name;
    private final AnalyzerDefinition definition = new AnalyzerDefinition();

    public ElasticsearchAnalyzerDefinitionContextImpl(String name) {
        this.name = name;
        this.definition.setType("custom");
    }

    @Override
    public ElasticsearchAnalyzerDefinitionWithTokenizerContext withTokenizer(String name) {
        this.definition.setTokenizer(name);
        return this;
    }

    @Override
    public ElasticsearchAnalyzerDefinitionWithTokenizerContext withCharFilters(String ... names) {
        this.definition.setCharFilters(null);
        for (String name : names) {
            this.definition.addCharFilter(name);
        }
        return this;
    }

    @Override
    public ElasticsearchAnalyzerDefinitionWithTokenizerContext withTokenFilters(String ... names) {
        this.definition.setTokenFilters(null);
        for (String name : names) {
            this.definition.addTokenFilter(name);
        }
        return this;
    }

    @Override
    public void populate(ElasticsearchAnalysisDefinitionRegistry registry) {
        if (StringHelper.isEmpty((String)this.definition.getTokenizer())) {
            throw LOG.invalidElasticsearchAnalyzerDefinition(this.name);
        }
        registry.register(this.name, this.definition);
    }
}

