/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;

public final class ElasticsearchEntityHelper {
    private ElasticsearchEntityHelper() {
    }

    public static boolean isMappedToElasticsearch(ExtendedSearchIntegrator integrator, IndexedTypeIdentifier entityType) {
        IndexedTypeSet entityTypesWithSubTypes = integrator.getIndexedTypesPolymorphic(entityType.asTypeSet());
        return ElasticsearchEntityHelper.hasElasticsearchIndexManager(integrator, entityTypesWithSubTypes);
    }

    public static boolean isAnyMappedToElasticsearch(ExtendedSearchIntegrator integrator, IndexedTypeSet entityTypes) {
        IndexedTypeSet entityTypesWithSubTypes = integrator.getIndexedTypesPolymorphic(entityTypes);
        return ElasticsearchEntityHelper.hasElasticsearchIndexManager(integrator, entityTypesWithSubTypes);
    }

    private static boolean hasElasticsearchIndexManager(ExtendedSearchIntegrator integrator, IndexedTypeSet entityTypes) {
        for (IndexedTypeIdentifier entityType : entityTypes) {
            IndexManagerType indexManagerType;
            EntityIndexBinding binding = integrator.getIndexBinding(entityType);
            if (binding == null || !ElasticsearchIndexManagerType.INSTANCE.equals(indexManagerType = binding.getIndexManagerType())) continue;
            return true;
        }
        return false;
    }
}

