/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.text.Collator;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.util.BytesRef;

public final class CollationDocValuesField
extends Field {
    private final String name;
    private final Collator collator;
    private final BytesRef bytes = new BytesRef();

    public CollationDocValuesField(String name, Collator collator) {
        super(name, SortedDocValuesField.TYPE);
        this.name = name;
        this.collator = (Collator)collator.clone();
        this.fieldsData = this.bytes;
    }

    public String name() {
        return this.name;
    }

    public void setStringValue(String value) {
        this.bytes.bytes = this.collator.getCollationKey(value).toByteArray();
        this.bytes.offset = 0;
        this.bytes.length = this.bytes.bytes.length;
    }
}

