/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.console.settings.VariableSettings;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.mapper.KeyMapper;
import org.jboss.aesh.io.FileResource;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.util.LoggerUtil;

public class Config {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String pathSeparator = System.getProperty("file.separator");
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    private static final boolean posixCompatible = Config.checkPosixCompability();
    private static boolean cygwin = false;
    private static final Logger LOGGER = LoggerUtil.getLogger(Config.class.getName());

    public static boolean isOSPOSIXCompatible() {
        return posixCompatible;
    }

    public static boolean isCygwin() {
        return cygwin;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getPathSeparator() {
        return pathSeparator;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getOS() {
        return System.getProperty("os.name");
    }

    private static boolean checkPosixCompability() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                int c;
                Process process = Runtime.getRuntime().exec(new String[]{"uname"});
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream in = process.getInputStream();
                while ((c = in.read()) != -1) {
                    bout.write(c);
                }
                process.waitFor();
                String output = new String(bout.toByteArray());
                if (output.toLowerCase().contains("cygwin")) {
                    cygwin = true;
                    return true;
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return false;
        }
        return !System.getProperty("os.name").startsWith("OS/2");
    }

    protected static Settings parseInputrc(Settings settings) throws IOException {
        if (!settings.getInputrc().isFile()) {
            if (settings.isLogging()) {
                LOGGER.info("Error while parsing: " + settings.getInputrc().getAbsolutePath() + " couldn't find file.");
            }
            return settings;
        }
        SettingsBuilder builder = new SettingsBuilder(settings);
        Pattern variablePattern = Pattern.compile("^set\\s+(\\S+)\\s+(\\S+)$");
        Pattern commentPattern = Pattern.compile("^#.*");
        Pattern keyQuoteNamePattern = Pattern.compile("(^\"\\\\\\S+)(\":\\s+)(\\S+)");
        Pattern keyNamePattern = Pattern.compile("(^\\S+)(:\\s+)(\\S+)");
        Pattern startConstructs = Pattern.compile("^\\$if");
        Pattern endConstructs = Pattern.compile("^\\$endif");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(settings.getInputrc()));
            boolean constructMode = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() < 1 || commentPattern.matcher(line).matches()) continue;
                if (startConstructs.matcher(line).matches()) {
                    constructMode = true;
                    continue;
                }
                if (endConstructs.matcher(line).matches()) {
                    constructMode = false;
                    continue;
                }
                if (constructMode) continue;
                Matcher variableMatcher = variablePattern.matcher(line);
                if (variableMatcher.matches()) {
                    Config.parseVariables(variableMatcher.group(1), variableMatcher.group(2), builder);
                }
                if (!Config.isOSPOSIXCompatible()) continue;
                Matcher keyQuoteMatcher = keyQuoteNamePattern.matcher(line);
                if (keyQuoteMatcher.matches()) {
                    builder.create().getOperationManager().addOperationIgnoreWorkingMode(KeyMapper.mapQuoteKeys(keyQuoteMatcher.group(1), keyQuoteMatcher.group(3)));
                    continue;
                }
                Matcher keyMatcher = keyNamePattern.matcher(line);
                if (!keyMatcher.matches()) continue;
                builder.create().getOperationManager().addOperationIgnoreWorkingMode(KeyMapper.mapKeys(keyMatcher.group(1), keyMatcher.group(3)));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read .inputrc: ", e);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.WARNING, "Exception during reading of inputrc: ", iae);
        }
        return builder.create();
    }

    private static void parseVariables(String variable, String value, SettingsBuilder builder) {
        if (variable.equals(VariableSettings.EDITING_MODE.getVariable())) {
            if (VariableSettings.EDITING_MODE.getValues().contains(value)) {
                if (value.equals("vi")) {
                    builder.mode(Mode.VI);
                } else {
                    builder.mode(Mode.EMACS);
                }
            } else if (builder.create().isLogging()) {
                LOGGER.warning("Value " + value + " not accepted for: " + variable + ", only: " + VariableSettings.EDITING_MODE.getValues());
            }
        } else if (variable.equals(VariableSettings.BELL_STYLE.getVariable())) {
            if (VariableSettings.BELL_STYLE.getValues().contains(value)) {
                builder.bellStyle(value);
            } else if (builder.create().isLogging()) {
                LOGGER.warning("Value " + value + " not accepted for: " + variable + ", only: " + VariableSettings.BELL_STYLE.getValues());
            }
        } else if (variable.equals(VariableSettings.HISTORY_SIZE.getVariable())) {
            try {
                builder.historySize(Integer.parseInt(value));
            }
            catch (NumberFormatException nfe) {
                if (builder.create().isLogging()) {
                    LOGGER.warning("Value " + value + " not accepted for: " + variable + ", it must be an integer.");
                }
            }
        } else if (variable.equals(VariableSettings.DISABLE_COMPLETION.getVariable())) {
            if (VariableSettings.DISABLE_COMPLETION.getValues().contains(value)) {
                if (value.equals("on")) {
                    builder.disableCompletion(true);
                } else {
                    builder.disableCompletion(false);
                }
            } else if (builder.create().isLogging()) {
                LOGGER.warning("Value " + value + " not accepted for: " + variable + ", only: " + VariableSettings.DISABLE_COMPLETION.getValues());
            }
        }
    }

    protected static Settings readRuntimeProperties(Settings settings) {
        SettingsBuilder builder;
        block23: {
            builder = new SettingsBuilder(settings);
            try {
                FileResource resourceFile;
                String executeFile;
                String execute;
                String ansi;
                String disableCompletion;
                String logFile;
                String doLogging;
                String historySize;
                String historyDisabled;
                String historyPersistent;
                String historyFile;
                String inputrc;
                String readInputrc;
                String editMode;
                String term = System.getProperty("aesh.terminal");
                if (term != null && term.length() > 0) {
                    builder.terminal((Terminal)settings.getClass().getClassLoader().loadClass(term).newInstance());
                }
                if ((editMode = System.getProperty("aesh.editmode")) != null && editMode.length() > 0) {
                    if (editMode.equalsIgnoreCase("VI")) {
                        builder.mode(Mode.VI);
                    } else if (editMode.equalsIgnoreCase("EMACS")) {
                        builder.mode(Mode.EMACS);
                    }
                }
                if ((readInputrc = System.getProperty("aesh.readinputrc")) != null && readInputrc.length() > 0 && (readInputrc.equalsIgnoreCase("true") || readInputrc.equalsIgnoreCase("false"))) {
                    builder.readInputrc(Boolean.parseBoolean(readInputrc));
                }
                if ((inputrc = System.getProperty("aesh.inputrc")) != null && inputrc.length() > 0 && new File(inputrc).isFile()) {
                    builder.inputrc(new File(inputrc));
                }
                if ((historyFile = System.getProperty("aesh.historyfile")) != null && historyFile.length() > 0 && new File(historyFile).isFile()) {
                    builder.historyFile(new File(historyFile));
                }
                if ((historyPersistent = System.getProperty("aesh.historypersistent")) != null && historyPersistent.length() > 0 && (historyPersistent.equalsIgnoreCase("true") || historyPersistent.equalsIgnoreCase("false"))) {
                    builder.persistHistory(Boolean.parseBoolean(historyPersistent));
                }
                if ((historyDisabled = System.getProperty("aesh.historydisabled")) != null && historyDisabled.length() > 0 && (historyDisabled.equalsIgnoreCase("true") || historyDisabled.equalsIgnoreCase("false"))) {
                    builder.disableHistory(Boolean.parseBoolean(historyDisabled));
                }
                if ((historySize = System.getProperty("aesh.historysize")) != null && historySize.length() > 0) {
                    builder.historySize(Integer.parseInt(historySize));
                }
                if ((doLogging = System.getProperty("aesh.logging")) != null && doLogging.length() > 0 && (doLogging.equalsIgnoreCase("true") || doLogging.equalsIgnoreCase("false"))) {
                    builder.logging(Boolean.parseBoolean(doLogging));
                }
                if ((logFile = System.getProperty("aesh.logfile")) != null && logFile.length() > 0) {
                    builder.logfile(logFile);
                }
                if ((disableCompletion = System.getProperty("aesh.disablecompletion")) != null && disableCompletion.length() > 0 && (disableCompletion.equalsIgnoreCase("true") || disableCompletion.equalsIgnoreCase("false"))) {
                    builder.disableCompletion(Boolean.parseBoolean(disableCompletion));
                }
                if ((ansi = System.getProperty("aesh.ansi")) != null && ansi.length() > 0 && (ansi.equalsIgnoreCase("true") || ansi.equalsIgnoreCase("false"))) {
                    builder.ansi(Boolean.parseBoolean(ansi));
                }
                if ((execute = System.getProperty("aesh.execute")) != null && execute.length() > 0) {
                    builder.setExecuteAtStart(execute);
                }
                if ((executeFile = System.getProperty("aesh.executefile")) != null && executeFile.length() > 0 && (resourceFile = new FileResource(executeFile)).isLeaf()) {
                    builder.setExecuteFileAtStart(resourceFile);
                }
            }
            catch (ClassNotFoundException e) {
                if (settings.isLogging()) {
                    LOGGER.log(Level.SEVERE, "Fail while finding class: ", e);
                }
            }
            catch (InstantiationException e) {
                if (settings.isLogging()) {
                    LOGGER.log(Level.SEVERE, "Fail while instantiating class: ", e);
                }
            }
            catch (IllegalAccessException e) {
                if (!settings.isLogging()) break block23;
                LOGGER.log(Level.SEVERE, "Fail while accessing class: ", e);
            }
        }
        return builder.create();
    }
}

