/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import javax.naming.NamingException;
import org.jboss.as.naming.ImmediateManagedReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.external.ExternalContexts;
import org.jboss.as.naming.deployment.Attachments;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class ContextNames {
    public static final ServiceName NAMING = ServiceName.JBOSS.append(new String[]{"naming"});
    public static final ServiceName JAVA_CONTEXT_SERVICE_NAME = NAMING.append(new String[]{"context", "java"});
    public static final ServiceName COMPONENT_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"comp"});
    public static final ServiceName JBOSS_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"jboss"});
    public static final ServiceName GLOBAL_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"global"});
    public static final ServiceName APPLICATION_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"app"});
    public static final ServiceName MODULE_CONTEXT_SERVICE_NAME = JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"module"});
    public static final ServiceName EXPORTED_CONTEXT_SERVICE_NAME = JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{"exported"});

    public static ServiceName contextServiceNameOfComponent(String app, String module, String comp) {
        return COMPONENT_CONTEXT_SERVICE_NAME.append(new String[]{app, module, comp});
    }

    public static ServiceName contextServiceNameOfModule(String app, String module) {
        return MODULE_CONTEXT_SERVICE_NAME.append(new String[]{app, module});
    }

    public static ServiceName contextServiceNameOfApplication(String app) {
        return APPLICATION_CONTEXT_SERVICE_NAME.append(new String[]{app});
    }

    public static BindInfo bindInfoFor(String app, String module, String comp, String context) {
        if (context.startsWith("java:")) {
            String namespace;
            int i = context.indexOf(47);
            if (i == -1) {
                namespace = context.substring(5);
            } else {
                if (i == 5) {
                    return new BindInfo(JAVA_CONTEXT_SERVICE_NAME, context.substring(6));
                }
                namespace = context.substring(5, i);
            }
            ContextNames.sanitazeNameSpace(namespace, context);
            if (namespace.equals("global")) {
                return new BindInfo(GLOBAL_CONTEXT_SERVICE_NAME, context.substring(12));
            }
            if (namespace.equals("jboss")) {
                String rest = context.substring(i);
                if (rest.startsWith("/exported/")) {
                    return new BindInfo(EXPORTED_CONTEXT_SERVICE_NAME, context.substring(20));
                }
                return new BindInfo(JBOSS_CONTEXT_SERVICE_NAME, context.substring(11));
            }
            if (namespace.equals("app")) {
                return new BindInfo(ContextNames.contextServiceNameOfApplication(app), context.substring(9));
            }
            if (namespace.equals("module")) {
                return new BindInfo(ContextNames.contextServiceNameOfModule(app, module), context.substring(12));
            }
            if (namespace.equals("comp")) {
                return new BindInfo(ContextNames.contextServiceNameOfComponent(app, module, comp), context.substring(10));
            }
            return new BindInfo(JBOSS_CONTEXT_SERVICE_NAME, context);
        }
        return null;
    }

    private static void sanitazeNameSpace(String namespace, String inContext) {
        if (namespace.contains(":")) {
            throw NamingLogger.ROOT_LOGGER.invalidJndiName(inContext);
        }
    }

    public static BindInfo bindInfoForEnvEntry(String app, String module, String comp, boolean useCompNamespace, String envEntryName) {
        if (envEntryName.startsWith("java:")) {
            if (useCompNamespace) {
                return ContextNames.bindInfoFor(app, module, comp, envEntryName);
            }
            if (envEntryName.startsWith("java:comp")) {
                return ContextNames.bindInfoFor(app, module, module, "java:module" + envEntryName.substring("java:comp".length()));
            }
            return ContextNames.bindInfoFor(app, module, module, envEntryName);
        }
        if (useCompNamespace) {
            return ContextNames.bindInfoFor(app, module, comp, "java:comp/env/" + envEntryName);
        }
        return ContextNames.bindInfoFor(app, module, module, "java:module/env/" + envEntryName);
    }

    public static ServiceName buildServiceName(ServiceName parentName, String relativeName) {
        return parentName.append(relativeName.split("/"));
    }

    public static BindInfo bindInfoFor(String jndiName) {
        ServiceName parentContextName;
        String bindName = jndiName.startsWith("java:") ? jndiName.substring(5) : (!jndiName.startsWith("jboss") && !jndiName.startsWith("global") && !jndiName.startsWith("/") ? "/" + jndiName : jndiName);
        if (bindName.startsWith("jboss/exported/")) {
            parentContextName = EXPORTED_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(15);
        } else if (bindName.startsWith("jboss/")) {
            parentContextName = JBOSS_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(6);
        } else if (bindName.startsWith("global/")) {
            parentContextName = GLOBAL_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(7);
        } else if (bindName.startsWith("/")) {
            parentContextName = JAVA_CONTEXT_SERVICE_NAME;
            bindName = bindName.substring(1);
        } else {
            throw NamingLogger.ROOT_LOGGER.illegalContextInName(jndiName);
        }
        return new BindInfo(parentContextName, bindName);
    }

    public static class BindInfo {
        private final ServiceName parentContextServiceName;
        private final ServiceName binderServiceName;
        private final String bindName;
        private final String absoluteJndiName;

        private BindInfo(ServiceName parentContextServiceName, String bindName) {
            this.parentContextServiceName = parentContextServiceName;
            this.binderServiceName = ContextNames.buildServiceName(parentContextServiceName, bindName);
            this.bindName = bindName;
            this.absoluteJndiName = this.generateAbsoluteJndiName();
        }

        public ServiceName getParentContextServiceName() {
            return this.parentContextServiceName;
        }

        public ServiceName getBinderServiceName() {
            return this.binderServiceName;
        }

        public String getBindName() {
            return this.bindName;
        }

        public String getAbsoluteJndiName() {
            return this.absoluteJndiName;
        }

        public String toString() {
            return "BindInfo{parentContextServiceName=" + this.parentContextServiceName + ", binderServiceName=" + this.binderServiceName + ", bindName='" + this.bindName + '\'' + '}';
        }

        private String generateAbsoluteJndiName() {
            StringBuffer sb = new StringBuffer();
            if (this.parentContextServiceName.equals(EXPORTED_CONTEXT_SERVICE_NAME)) {
                sb.append("java:jboss/exported/");
            } else if (this.parentContextServiceName.equals(JBOSS_CONTEXT_SERVICE_NAME)) {
                sb.append("java:jboss/");
            } else if (this.parentContextServiceName.equals(APPLICATION_CONTEXT_SERVICE_NAME)) {
                sb.append("java:app/");
            } else if (this.parentContextServiceName.equals(MODULE_CONTEXT_SERVICE_NAME)) {
                sb.append("java:module/");
            } else if (this.parentContextServiceName.equals(COMPONENT_CONTEXT_SERVICE_NAME)) {
                sb.append("java:comp/");
            } else if (this.parentContextServiceName.equals(GLOBAL_CONTEXT_SERVICE_NAME)) {
                sb.append("java:global/");
            } else if (this.parentContextServiceName.equals(JAVA_CONTEXT_SERVICE_NAME)) {
                sb.append("java:/");
            }
            sb.append(this.bindName);
            return sb.toString();
        }

        public void setupLookupInjection(ServiceBuilder<?> serviceBuilder, final Injector<ManagedReferenceFactory> targetInjector, DeploymentUnit deploymentUnit, final boolean optional) {
            ExternalContexts externalContexts = (ExternalContexts)deploymentUnit.getAttachment(Attachments.EXTERNAL_CONTEXTS);
            ServiceName parentExternalContextServiceName = externalContexts != null ? externalContexts.getParentExternalContext(this.getBinderServiceName()) : null;
            ServiceName dependencyServiceName = parentExternalContextServiceName == null ? this.getBinderServiceName() : parentExternalContextServiceName;
            ServiceBuilder.DependencyType dependencyType = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            serviceBuilder.addDependency(dependencyType, dependencyServiceName);
            Injector<NamingStore> lookupInjector = new Injector<NamingStore>(){

                public void uninject() {
                    targetInjector.uninject();
                }

                public void inject(NamingStore value) throws InjectionException {
                    final NamingContext storeBaseContext = new NamingContext(value, null);
                    ManagedReferenceFactory factory = new ManagedReferenceFactory(){

                        @Override
                        public ManagedReference getReference() {
                            try {
                                return new ImmediateManagedReference(storeBaseContext.lookup(this.getBindName()));
                            }
                            catch (NamingException e) {
                                if (!optional) {
                                    throw NamingLogger.ROOT_LOGGER.resourceLookupForInjectionFailed(this.getAbsoluteJndiName(), e);
                                }
                                NamingLogger.ROOT_LOGGER.tracef(e, "failed to lookup %s", this.getAbsoluteJndiName());
                                return null;
                            }
                        }
                    };
                    targetInjector.inject((Object)factory);
                }
            };
            serviceBuilder.addDependency(this.getParentContextServiceName(), NamingStore.class, (Injector)lookupInjector);
        }
    }
}

