/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.AeshCommandLineCompletionParser;
import org.jboss.aesh.cl.parser.ArgumentParserException;
import org.jboss.aesh.cl.parser.CommandLineCompletionParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.parser.RequiredOptionException;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.parser.ParserStatus;

public class AeshCommandLineParser<C extends Command>
implements CommandLineParser<C> {
    private final ProcessedCommand<C> processedCommand;
    private static final String EQUALS = "=";
    private List<CommandLineParser<? extends Command>> childParsers;
    private boolean isChild = false;

    public AeshCommandLineParser(ProcessedCommand<C> processedCommand) {
        this.processedCommand = processedCommand;
    }

    @Override
    public void addChildParser(CommandLineParser<? extends Command> commandLineParser) {
        if (this.childParsers == null) {
            this.childParsers = new ArrayList<CommandLineParser<? extends Command>>();
        }
        commandLineParser.setChild(true);
        this.childParsers.add(commandLineParser);
    }

    @Override
    public void setChild(boolean child) {
        this.isChild = child;
    }

    @Override
    public List<String> getAllNames() {
        if (this.isGroupCommand()) {
            ArrayList<String> names = new ArrayList<String>(this.childParsers.size());
            for (CommandLineParser<? extends Command> child : this.childParsers) {
                names.add(this.processedCommand.getName() + " " + child.getProcessedCommand().getName());
            }
            return names;
        }
        ArrayList<String> names = new ArrayList<String>(1);
        names.add(this.processedCommand.getName());
        return names;
    }

    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public CommandLineParser<? extends Command> getChildParser(String name) {
        if (!this.isGroupCommand()) {
            return null;
        }
        for (CommandLineParser<? extends Command> clp : this.childParsers) {
            if (!clp.getProcessedCommand().getName().equals(name)) continue;
            return clp;
        }
        return null;
    }

    @Override
    public List<CommandLineParser<? extends Command>> getAllChildParsers() {
        if (this.isGroupCommand()) {
            return this.childParsers;
        }
        return new ArrayList<CommandLineParser<? extends Command>>();
    }

    @Override
    public ProcessedCommand<C> getProcessedCommand() {
        return this.processedCommand;
    }

    @Override
    public C getCommand() {
        return this.processedCommand.getCommand();
    }

    @Override
    public CommandLineCompletionParser getCompletionParser() {
        return new AeshCommandLineCompletionParser(this);
    }

    @Override
    public CommandPopulator getCommandPopulator() {
        return this.processedCommand.getCommandPopulator();
    }

    @Override
    public String printHelp() {
        if (this.childParsers != null && this.childParsers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.processedCommand.printHelp()).append(Config.getLineSeparator()).append(this.processedCommand.getName()).append(" commands:").append(Config.getLineSeparator());
            for (CommandLineParser<? extends Command> child : this.childParsers) {
                sb.append("    ").append(child.getProcessedCommand().getName()).append(Config.getLineSeparator());
            }
            return sb.toString();
        }
        return this.processedCommand.printHelp();
    }

    @Override
    public CommandLine<? extends Command> parse(String line) {
        return this.parse(line, false);
    }

    @Override
    public CommandLine<? extends Command> parse(AeshLine line, boolean ignoreRequirements) {
        if (line.getWords().size() > 0) {
            if (this.processedCommand.getName().equals(line.getWords().get(0))) {
                if (this.isGroupCommand() && line.getWords().size() > 1) {
                    CommandLineParser<Command> clp = this.getChildParser(line.getWords().get(1));
                    if (clp == null) {
                        return this.parse(line.getWords(), ignoreRequirements);
                    }
                    return clp.parse(line.getWords(), ignoreRequirements);
                }
                return this.parse(line.getWords(), ignoreRequirements);
            }
        } else if (line.getStatus() != ParserStatus.OK) {
            return new CommandLine(new CommandLineParserException(line.getErrorMessage()));
        }
        return new CommandLine(new CommandLineParserException("Command:" + this.processedCommand + ", not found in: " + line));
    }

    @Override
    public CommandLine<? extends Command> parse(String line, boolean ignoreRequirements) {
        return this.parse(Parser.findAllWords(line), ignoreRequirements);
    }

    @Override
    public CommandLine<? extends Command> parse(List<String> lines, boolean ignoreRequirements) {
        RequiredOptionException re;
        this.clear();
        CommandLine commandLine = new CommandLine(this);
        if (this.processedCommand.hasArgument()) {
            commandLine.setArgument(this.processedCommand.getArgument());
        }
        ProcessedOption active = null;
        boolean addedArgument = false;
        int startWord = 1;
        if (this.isChild) {
            startWord = 2;
        }
        for (int i = startWord; i < lines.size(); ++i) {
            int n;
            String parseLine = lines.get(i);
            ProcessedOption currentOption = null;
            if (parseLine.startsWith("--")) {
                currentOption = this.findLongOption(this.processedCommand, parseLine.substring(2));
                if (currentOption != null) {
                    currentOption.setLongNameUsed(true);
                }
            } else if (parseLine.startsWith("-") && (currentOption = this.findOption(this.processedCommand, parseLine.substring(1, 2))) != null) {
                currentOption.setLongNameUsed(false);
            }
            if (currentOption != null) {
                Object name;
                if (currentOption.isLongNameUsed()) {
                    if (active != null) {
                        if (active.getOptionType() == OptionType.LIST || active.getOptionType() == OptionType.GROUP) {
                            commandLine.addOption(active);
                            active = null;
                        } else if (active.getDefaultValues() != null && active.getDefaultValues().size() > 0) {
                            active.addValue(active.getDefaultValues().get(0));
                            commandLine.addOption(active);
                            active = null;
                        } else {
                            commandLine.setParserException(new OptionParserException("Option: " + active.getDisplayName() + " must be given a value"));
                            break;
                        }
                    }
                    if ((active = currentOption).isProperty()) {
                        if (parseLine.length() <= 2 + active.getName().length() || !parseLine.contains(EQUALS)) {
                            commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must be part of a property"));
                            continue;
                        }
                        name = parseLine.substring(2 + active.getName().length(), parseLine.indexOf(EQUALS));
                        String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                        if (value.length() < 1) {
                            commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must have a value"));
                            continue;
                        }
                        active.addProperty((String)name, value);
                        commandLine.addOption(active);
                        active = null;
                        if (!addedArgument) continue;
                        commandLine.setParserException(new ArgumentParserException("An argument was given to an option that does not support it."));
                        continue;
                    }
                    if (active.getValue() != null) {
                        if (active.getEndsWithSeparator()) continue;
                        commandLine.addOption(active);
                        active = null;
                        continue;
                    }
                    if (active.getOptionType().equals((Object)OptionType.BOOLEAN) && (!active.hasValue() || active.getValue() != null)) {
                        active.addValue("true");
                        commandLine.addOption(active);
                        active = null;
                        if (!addedArgument) continue;
                        commandLine.setParserException(new ArgumentParserException("An argument was given to an option that does not support it."));
                        continue;
                    }
                    if (active != null) continue;
                    commandLine.setParserException(new OptionParserException("Option: " + parseLine + " is not a valid option for this command"));
                    continue;
                }
                if (currentOption.isLongNameUsed()) continue;
                if (active != null) {
                    if (active.getOptionType() == OptionType.LIST || active.getOptionType() == OptionType.GROUP) {
                        commandLine.addOption(active);
                        active = null;
                        continue;
                    }
                    if (active.getDefaultValues() != null && active.getDefaultValues().size() > 0) {
                        active.addValue(active.getDefaultValues().get(0));
                        commandLine.addOption(active);
                        active = null;
                        continue;
                    }
                    commandLine.setParserException(new OptionParserException("Option: " + active.getDisplayName() + " must be given a value"));
                    break;
                }
                if (parseLine.length() != 2 && !parseLine.contains(EQUALS)) {
                    if (parseLine.length() > 2) {
                        name = parseLine.substring(1).toCharArray();
                        int value = ((char[])name).length;
                        for (n = 0; n < value; ++n) {
                            char shortName = name[n];
                            active = this.findOption(this.processedCommand, String.valueOf(shortName));
                            if (active != null) {
                                if (!active.hasValue()) {
                                    active.setLongNameUsed(false);
                                    active.addValue("true");
                                    commandLine.addOption(active);
                                    continue;
                                }
                                commandLine.setParserException(new OptionParserException("Option: -" + shortName + " can not be grouped with other options since it need to be given a value"));
                                continue;
                            }
                            commandLine.setParserException(new OptionParserException("Option: -" + shortName + " was not found."));
                        }
                        active = null;
                        continue;
                    }
                    commandLine.setParserException(new OptionParserException("Option: - must be followed by a valid operator"));
                    continue;
                }
                active = this.findOption(this.processedCommand, parseLine.substring(1));
                if (active != null) {
                    active.setLongNameUsed(false);
                }
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 || !parseLine.contains(EQUALS)) {
                        commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must be part of a property"));
                        continue;
                    }
                    name = parseLine.substring(2, parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    if (value.length() < 1) {
                        commandLine.setParserException(new OptionParserException("Option " + active.getDisplayName() + ", must have a value"));
                        continue;
                    }
                    active.addProperty((String)name, value);
                    commandLine.addOption(active);
                    active = null;
                    if (!addedArgument) continue;
                    commandLine.setParserException(new OptionParserException("An argument was given to an option that does not support it."));
                    continue;
                }
                if (active.getValue() != null) {
                    if (active.getEndsWithSeparator()) continue;
                    commandLine.addOption(active);
                    active = null;
                    continue;
                }
                if (active != null && active.getOptionType().equals((Object)OptionType.BOOLEAN) && (!active.hasValue() || active.getValue() != null)) {
                    active.addValue("true");
                    commandLine.addOption(active);
                    active = null;
                    if (!addedArgument) continue;
                    commandLine.setParserException(new OptionParserException("An argument was given to an option that does not support it."));
                    continue;
                }
                if (active != null) continue;
                commandLine.setParserException(new OptionParserException("Option: " + parseLine + " is not a valid option for this command"));
                continue;
            }
            if (active != null) {
                if (active.hasMultipleValues()) {
                    if (parseLine.contains(String.valueOf(active.getValueSeparator()))) {
                        String[] stringArray = parseLine.split(String.valueOf(active.getValueSeparator()));
                        int n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            String value = stringArray[n];
                            active.addValue(value.trim());
                        }
                        if (parseLine.endsWith(String.valueOf(active.getValueSeparator()))) {
                            active.setEndsWithSeparator(true);
                        }
                        commandLine.addOption(active);
                        active = null;
                    } else {
                        active.addValue(parseLine);
                    }
                } else {
                    active.addValue(parseLine);
                }
                if (active != null && (active.getOptionType() == OptionType.NORMAL || active.getOptionType() == OptionType.BOOLEAN)) {
                    commandLine.addOption(active);
                    active = null;
                }
                if (!addedArgument) continue;
                commandLine.setParserException(new OptionParserException("An argument was given to an option that does not support it."));
                continue;
            }
            if (parseLine.startsWith("-")) {
                commandLine.setParserException(new OptionParserException("Option: " + parseLine + " was not found."));
                continue;
            }
            if (this.processedCommand.getArgument() == null) {
                commandLine.setParserException(new OptionParserException("An argument was given to a command that does not support it."));
                continue;
            }
            commandLine.addArgumentValue(parseLine);
            addedArgument = true;
        }
        if (active != null && (ignoreRequirements || active.getOptionType() == OptionType.LIST || active.getOptionType() == OptionType.GROUP)) {
            commandLine.addOption(active);
        } else if (active != null && active.getOptionType() == OptionType.NORMAL && active.hasDefaultValue() && active.hasValue()) {
            active.addValue(active.getDefaultValues().get(0));
            commandLine.addOption(active);
        }
        if (!ignoreRequirements && (re = this.checkForMissingRequiredOptions(this.processedCommand, commandLine)) != null) {
            commandLine.setParserException(re);
        }
        return commandLine;
    }

    private RequiredOptionException checkForMissingRequiredOptions(ProcessedCommand<C> command, CommandLine<? extends Command> commandLine) {
        for (ProcessedOption o : command.getOptions()) {
            if (!o.isRequired()) continue;
            boolean found = false;
            for (ProcessedOption po : commandLine.getOptions()) {
                if (po.getShortName() != null && o.getShortName() != null && po.getShortName().equals(o.getShortName()) || po.getName() != null && po.getName().equals(o.getName())) {
                    found = true;
                    break;
                }
                if (!po.doOverrideRequired()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return new RequiredOptionException("Option: " + o.getDisplayName() + " is required for this command.");
        }
        return null;
    }

    private ProcessedOption findOption(ProcessedCommand command, String line) {
        String rest;
        ProcessedOption option = command.findOption(line);
        if (option != null) {
            return option;
        }
        option = command.startWithOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getShortName().length())).length() > 1 && rest.startsWith(EQUALS)) {
            if (option.getOptionType().equals((Object)OptionType.LIST) && rest.indexOf(option.getValueSeparator()) > -1) {
                for (String value : rest.substring(1).split(String.valueOf(option.getValueSeparator()))) {
                    option.addValue(value.trim());
                }
                if (rest.endsWith(String.valueOf(option.getValueSeparator()))) {
                    option.setEndsWithSeparator(true);
                }
            } else {
                option.addValue(rest.substring(1));
            }
            return option;
        }
        return null;
    }

    private ProcessedOption findLongOption(ProcessedCommand command, String line) {
        String rest;
        ProcessedOption option = command.findLongOptionNoActivatorCheck(line);
        if (option != null) {
            return option;
        }
        option = command.startWithLongOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getName().length())).length() > 1 && rest.startsWith(EQUALS)) {
            if (option.getOptionType().equals((Object)OptionType.LIST) && rest.indexOf(option.getValueSeparator()) > -1) {
                for (String value : rest.substring(1).split(String.valueOf(option.getValueSeparator()))) {
                    option.addValue(value.trim());
                }
                if (rest.endsWith(String.valueOf(option.getValueSeparator()))) {
                    option.setEndsWithSeparator(true);
                }
            } else {
                option.addValue(rest.substring(1));
            }
            return option;
        }
        return null;
    }

    @Override
    public void clear() {
        this.processedCommand.clear();
        if (this.isGroupCommand()) {
            for (CommandLineParser<? extends Command> child : this.childParsers) {
                child.getProcessedCommand().clear();
            }
        }
    }

    @Override
    public boolean isGroupCommand() {
        return this.childParsers != null && this.childParsers.size() > 0;
    }

    public String toString() {
        return "CommandLineParser{processedCommand=" + this.processedCommand + "command=" + this.processedCommand.getCommand() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AeshCommandLineParser)) {
            return false;
        }
        AeshCommandLineParser that = (AeshCommandLineParser)o;
        return this.processedCommand.equals(that.processedCommand);
    }

    public int hashCode() {
        return this.processedCommand.hashCode();
    }
}

