/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.jboss.logging.Logger;

public class JAASSecurityManager
implements ActiveMQSecurityManager {
    private static final Logger logger = Logger.getLogger(JAASSecurityManager.class);
    private String configurationName;
    private CallbackHandler callbackHandler;
    private Configuration config;

    @Override
    public boolean validateUser(String user, String password) {
        try {
            this.getAuthenticatedSubject(user, password);
            return true;
        }
        catch (LoginException e1) {
            return false;
        }
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        Subject localSubject = null;
        try {
            localSubject = this.getAuthenticatedSubject(user, password);
        }
        catch (LoginException e1) {
            return false;
        }
        boolean authenticated = true;
        if (localSubject != null) {
            Set<Principal> rolePrincipals = this.getRolePrincipals(checkType, roles);
            boolean hasRole = false;
            Group subjectRoles = this.getSubjectRoles(localSubject);
            if (subjectRoles != null) {
                Iterator<Principal> iter = rolePrincipals.iterator();
                while (!hasRole && iter.hasNext()) {
                    Principal role = iter.next();
                    hasRole = subjectRoles.isMember(role);
                }
            }
            authenticated = hasRole;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("user " + user + (authenticated ? " is " : " is NOT ") + "authorized"));
            }
        }
        return authenticated;
    }

    private Subject getAuthenticatedSubject(String user, String password) throws LoginException {
        SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        Subject subject = new Subject();
        if (user != null) {
            subject.getPrincipals().add(principal);
        }
        subject.getPrivateCredentials().add(passwordChars);
        LoginContext lc = new LoginContext(this.configurationName, subject, this.callbackHandler, this.config);
        lc.login();
        return lc.getSubject();
    }

    private Group getSubjectRoles(Subject subject) {
        Set<Group> subjectGroups = subject.getPrincipals(Group.class);
        Iterator<Group> iter = subjectGroups.iterator();
        Group roles = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roles = grp;
        }
        return roles;
    }

    private Set<Principal> getRolePrincipals(CheckType checkType, Set<Role> roles) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            principals.add(new SimplePrincipal(role.getName()));
        }
        return principals;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public static class SimplePrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;

        public SimplePrincipal(String name) {
            this.name = name;
        }

        @Override
        public boolean equals(Object another) {
            if (!(another instanceof Principal)) {
                return false;
            }
            String anotherName = ((Principal)another).getName();
            boolean equals = false;
            equals = this.name == null ? anotherName == null : this.name.equals(anotherName);
            return equals;
        }

        @Override
        public int hashCode() {
            return this.name == null ? 0 : this.name.hashCode();
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

