/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.BackupWriteRpcCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.UserRaisedFunctionalException;

public class ComputeIfAbsentCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final int COMMAND_ID = 69;
    private Function mappingFunction;
    private Metadata metadata;
    private CacheNotifier<Object, Object> notifier;
    private boolean successful = false;

    public ComputeIfAbsentCommand() {
    }

    public ComputeIfAbsentCommand(Object key, Function mappingFunction, long flagsBitSet, CommandInvocationId commandInvocationId, Metadata metadata, CacheNotifier notifier, ComponentRegistry componentRegistry) {
        super(key, flagsBitSet, commandInvocationId);
        this.mappingFunction = mappingFunction;
        this.metadata = metadata;
        this.notifier = notifier;
        componentRegistry.wireDependencies(this.mappingFunction);
    }

    public void init(CacheNotifier notifier, ComponentRegistry componentRegistry) {
        this.notifier = notifier;
        componentRegistry.wireDependencies(this.mappingFunction);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            throw new IllegalStateException("Not wrapped");
        }
        Object value = e.getValue();
        if (value == null) {
            try {
                value = this.mappingFunction.apply(this.key);
            }
            catch (RuntimeException ex) {
                throw new UserRaisedFunctionalException(ex);
            }
            if (value != null) {
                e.setValue(value);
                Metadatas.updateMetadata(e, this.metadata);
                if (e.isCreated()) {
                    this.notifier.notifyCacheEntryCreated(this.key, value, this.metadata, true, ctx, this);
                }
                if (e.isRemoved()) {
                    e.setCreated(true);
                    e.setExpired(false);
                    e.setRemoved(false);
                    e.setValid(true);
                }
                e.setChanged(true);
            }
            this.successful = true;
        }
        return value;
    }

    public Function getMappingFunction() {
        return this.mappingFunction;
    }

    @Override
    public byte getCommandId() {
        return 69;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.mappingFunction);
        output.writeObject(this.metadata);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.mappingFunction = (Function)input.readObject();
        this.metadata = (Metadata)input.readObject();
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitComputeIfAbsentCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public void initBackupWriteRpcCommand(BackupWriteRpcCommand command) {
        command.setComputeIfAbsent(this.commandInvocationId, this.key, this.mappingFunction, this.metadata, this.getFlagsBitSet(), this.getTopologyId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComputeIfAbsentCommand that = (ComputeIfAbsentCommand)o;
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.mappingFunction, this.mappingFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mappingFunction, this.metadata);
    }

    @Override
    public String toString() {
        return "ComputeIfAbsentCommand{key=" + Util.toStr((Object)this.key) + ", mappingFunction=" + Util.toStr((Object)this.mappingFunction) + ", metadata=" + this.metadata + ", flags=" + this.printFlags() + ", successful=" + this.isSuccessful() + ", valueMatcher=" + (Object)((Object)this.getValueMatcher()) + ", topologyId=" + this.getTopologyId() + '}';
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }
}

