/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongUnaryOperator;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.eviction.EvictionType;
import org.infinispan.metadata.Metadata;

public class BoundedOffHeapDataContainer
extends OffHeapDataContainer {
    private final long maxSize;
    private final Lock lruLock;
    private final LongUnaryOperator sizeCalculator;
    private long currentSize;
    private long firstAddress;
    private long lastAddress;

    public BoundedOffHeapDataContainer(int desiredSize, long maxSize, EvictionType type) {
        super(desiredSize);
        this.maxSize = maxSize;
        this.sizeCalculator = type == EvictionType.COUNT ? i -> 1L : i -> this.offHeapEntryFactory.determineSize(i) + 28L;
        this.lruLock = new ReentrantLock();
        this.firstAddress = 0L;
    }

    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        super.put(key, value, metadata);
        this.ensureSize();
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryReplaced(long newAddress, long oldAddress) {
        long oldSize = this.sizeCalculator.applyAsLong(oldAddress);
        long newSize = this.sizeCalculator.applyAsLong(newAddress);
        this.lruLock.lock();
        try {
            long lruNode = UNSAFE.getLong(oldAddress);
            if (this.trace) {
                this.log.tracef("Replacing LRU node: %d. OldValue: %d NewValue: %d", lruNode, oldAddress, newAddress);
            }
            UNSAFE.putLong(newAddress, lruNode);
            UNSAFE.putLong(lruNode, newAddress);
            this.moveToEnd(lruNode);
            this.currentSize += newSize;
            this.currentSize -= oldSize;
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryReplaced(newAddress, oldAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryCreated(long newAddress) {
        int hashCode = this.offHeapEntryFactory.getHashCodeForAddress(newAddress);
        long newSize = this.sizeCalculator.applyAsLong(newAddress);
        this.lruLock.lock();
        try {
            this.currentSize += newSize;
            this.addEntryAddressToEnd(newAddress, hashCode);
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryCreated(newAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryRemoved(long removedAddress) {
        long removedSize = this.sizeCalculator.applyAsLong(removedAddress);
        long lruNode = UNSAFE.getLong(removedAddress);
        this.lruLock.lock();
        try {
            long previousLRUNode;
            this.currentSize -= removedSize;
            boolean middleNode = true;
            if (lruNode == this.lastAddress) {
                if (this.trace) {
                    this.log.tracef("Removing last LRU node at %d", lruNode);
                }
                if ((previousLRUNode = UNSAFE.getLong(lruNode + 8L)) != 0L) {
                    UNSAFE.putLong(previousLRUNode + 16L, 0L);
                }
                this.lastAddress = previousLRUNode;
                middleNode = false;
            }
            if (lruNode == this.firstAddress) {
                long nextLRUNode;
                if (this.trace) {
                    this.log.tracef("Removing first LRU node at %d", lruNode);
                }
                if ((nextLRUNode = UNSAFE.getLong(lruNode + 16L)) != 0L) {
                    UNSAFE.putLong(nextLRUNode + 8L, 0L);
                }
                this.firstAddress = nextLRUNode;
                middleNode = false;
            }
            if (middleNode) {
                if (this.trace) {
                    this.log.tracef("Removing middle LRU node at %d", lruNode);
                }
                previousLRUNode = UNSAFE.getLong(lruNode + 8L);
                long nextLRUNode = UNSAFE.getLong(lruNode + 16L);
                assert (previousLRUNode != 0L);
                assert (nextLRUNode != 0L);
                UNSAFE.putLong(previousLRUNode + 16L, nextLRUNode);
                UNSAFE.putLong(nextLRUNode + 8L, previousLRUNode);
            }
            this.allocator.deallocate(lruNode, 28L);
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryRemoved(removedAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void entryRetrieved(long entryAddress) {
        this.lruLock.lock();
        try {
            long lruNode = UNSAFE.getLong(entryAddress);
            if (this.trace) {
                this.log.tracef("Moving lruNode %d to the end which points at address %d", lruNode, entryAddress);
            }
            this.moveToEnd(lruNode);
        }
        finally {
            this.lruLock.unlock();
        }
        super.entryRetrieved(entryAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performClear() {
        if (this.trace) {
            this.log.trace("Clearing bounded LRU entries");
        }
        this.lruLock.lock();
        try {
            long address = this.firstAddress;
            while (address != 0L) {
                long nextAddress = UNSAFE.getLong(address + 16L);
                this.allocator.deallocate(address, 28L);
                address = nextAddress;
            }
            this.currentSize = 0L;
            this.firstAddress = 0L;
            this.lastAddress = 0L;
        }
        finally {
            this.lruLock.unlock();
        }
        if (this.trace) {
            this.log.trace("Cleared bounded LRU entries");
        }
        super.performClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureSize() {
        while (true) {
            long addressToRemove;
            Lock entryWriteLock;
            int hashCode;
            this.lruLock.lock();
            try {
                if (this.currentSize <= this.maxSize) return;
                hashCode = UNSAFE.getInt(this.firstAddress + 24L);
                entryWriteLock = this.locks.getLockFromHashCode(hashCode).writeLock();
                addressToRemove = !entryWriteLock.tryLock() ? 0L : UNSAFE.getLong(this.firstAddress);
            }
            finally {
                this.lruLock.unlock();
            }
            if (addressToRemove == 0L) {
                entryWriteLock.lock();
                try {
                    this.lruLock.lock();
                    try {
                        if (this.currentSize <= this.maxSize) return;
                        hashCode = UNSAFE.getInt(this.firstAddress + 24L);
                        Lock innerLock = this.locks.getLockFromHashCode(hashCode).writeLock();
                        addressToRemove = innerLock == entryWriteLock ? UNSAFE.getLong(this.firstAddress) : 0L;
                    }
                    finally {
                        this.lruLock.unlock();
                    }
                }
                finally {
                    if (addressToRemove == 0L) {
                        entryWriteLock.unlock();
                    }
                }
            }
            if (addressToRemove == 0L) continue;
            if (this.trace) {
                this.log.tracef("Removing entry: %d due to eviction due to size %d being larger than maximum of %d", addressToRemove, this.currentSize, this.maxSize);
            }
            try {
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(addressToRemove);
                this.passivator.passivate(ice);
                this.performRemove(addressToRemove, this.offHeapEntryFactory.getKey(addressToRemove));
                this.evictionManager.onEntryEviction(Collections.singletonMap(ice.getKey(), ice));
                continue;
            }
            finally {
                entryWriteLock.unlock();
                continue;
            }
            break;
        }
    }

    private void addEntryAddressToEnd(long entryAddress, int hashCode) {
        long nodeAddress = this.allocator.allocate(28L);
        if (this.trace) {
            this.log.tracef("Creating LRU node %d for new entry %d", nodeAddress, entryAddress);
        }
        UNSAFE.putLong(nodeAddress, entryAddress);
        UNSAFE.putLong(entryAddress, nodeAddress);
        if (this.lastAddress == 0L) {
            this.firstAddress = nodeAddress;
            this.lastAddress = nodeAddress;
            UNSAFE.putLong(nodeAddress + 8L, 0L);
        } else {
            UNSAFE.putLong(nodeAddress + 8L, this.lastAddress);
            UNSAFE.putLong(this.lastAddress + 16L, nodeAddress);
            this.lastAddress = nodeAddress;
        }
        UNSAFE.putLong(nodeAddress + 16L, 0L);
        UNSAFE.putInt(nodeAddress + 24L, hashCode);
    }

    private void moveToEnd(long lruNode) {
        if (lruNode != this.lastAddress) {
            long nextLruNode = UNSAFE.getLong(lruNode + 16L);
            if (lruNode == this.firstAddress) {
                UNSAFE.putLong(nextLruNode + 8L, 0L);
                this.firstAddress = nextLruNode;
            } else {
                long prevLruNode = UNSAFE.getLong(lruNode + 8L);
                UNSAFE.putLong(prevLruNode + 16L, nextLruNode);
                UNSAFE.putLong(nextLruNode + 8L, prevLruNode);
            }
            UNSAFE.putLong(this.lastAddress + 16L, lruNode);
            UNSAFE.putLong(lruNode + 8L, this.lastAddress);
            UNSAFE.putLong(lruNode + 16L, 0L);
            this.lastAddress = lruNode;
        }
    }
}

