/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.interceptors.distribution.CountDownCompletableFuture;
import org.infinispan.interceptors.distribution.MergingCompletableFuture;
import org.infinispan.interceptors.distribution.PutMapHelper;
import org.infinispan.interceptors.distribution.ReadWriteManyEntriesHelper;
import org.infinispan.interceptors.distribution.ReadWriteManyHelper;
import org.infinispan.interceptors.distribution.WriteManyCommandHelper;
import org.infinispan.interceptors.distribution.WriteOnlyManyEntriesHelper;
import org.infinispan.interceptors.distribution.WriteOnlyManyHelper;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final PutMapHelper putMapHelper = new PutMapHelper(this::createRemoteCallback);
    private final ReadWriteManyHelper readWriteManyHelper = new ReadWriteManyHelper(this::createRemoteCallback);
    private final ReadWriteManyEntriesHelper readWriteManyEntriesHelper = new ReadWriteManyEntriesHelper(this::createRemoteCallback);
    private final WriteOnlyManyEntriesHelper writeOnlyManyEntriesHelper = new WriteOnlyManyEntriesHelper(this::createRemoteCallback);
    private final WriteOnlyManyHelper writeOnlyManyHelper = new WriteOnlyManyHelper(this::createRemoteCallback);

    private Map<Address, Set<Integer>> primaryOwnersOfSegments(ConsistentHash ch) {
        HashMap<Address, Set<Integer>> map = new HashMap<Address, Set<Integer>>(ch.getMembers().size());
        for (int segment = 0; segment < ch.getNumSegments(); ++segment) {
            Address owner = ch.locatePrimaryOwnerForSegment(segment);
            map.computeIfAbsent(owner, o -> new HashSet()).add(segment);
        }
        return map;
    }

    private Map<Address, Set<Integer>> backupOwnersOfSegments(ConsistentHash ch, Set<Integer> segments) {
        HashMap<Address, Set<Integer>> map = new HashMap<Address, Set<Integer>>(ch.getMembers().size());
        if (ch.isReplicated()) {
            for (Address member : ch.getMembers()) {
                map.put(member, segments);
            }
            map.remove(this.rpcManager.getAddress());
        } else {
            for (Integer segment : segments) {
                List<Address> owners = ch.locateOwnersForSegment(segment);
                for (int i = 1; i < owners.size(); ++i) {
                    map.computeIfAbsent(owners.get(i), o -> new HashSet()).add(segment);
                }
            }
        }
        return map;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.putMapHelper);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteOnlyManyCommand(ctx, command, this.writeOnlyManyEntriesHelper);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteOnlyManyCommand(ctx, command, this.writeOnlyManyHelper);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.readWriteManyHelper);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.readWriteManyEntriesHelper);
    }

    private <C extends WriteCommand, Container, Item> Object handleWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper) throws Exception {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        if (ctx.isOriginLocal()) {
            Map<Address, Set<Integer>> segmentMap = this.primaryOwnersOfSegments(ch);
            CountDownCompletableFuture allFuture = new CountDownCompletableFuture(segmentMap.size());
            for (Map.Entry<Address, Set<Integer>> pair : segmentMap.entrySet()) {
                Address member = pair.getKey();
                Set<Integer> segments = pair.getValue();
                this.handleSegmentsForWriteOnlyManyCommand(ctx, command, helper, ch, allFuture, member, segments);
            }
            return NonTxDistributionInterceptor.asyncValue(allFuture);
        }
        return this.handleRemoteWriteOnlyManyCommand(ctx, command, helper);
    }

    private <C extends WriteCommand, Container, Item> void handleSegmentsForWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper, ConsistentHash ch, CountDownCompletableFuture allFuture, Address member, Set<Integer> segments) {
        if (member.equals(this.rpcManager.getAddress())) {
            Container myItems = this.filterAndWrap(ctx, command, segments, helper);
            C localCommand = helper.copyForLocal(command, myItems);
            this.invokeNextAndFinally(ctx, (VisitableCommand)localCommand, this.createLocalInvocationHandler(ch, allFuture, segments, helper, (f, rv) -> {}));
            return;
        }
        C copy = helper.copyForPrimary(command, ch, segments);
        int size = helper.getItems(copy).size();
        if (size <= 0) {
            allFuture.countDown();
            return;
        }
        this.rpcManager.invokeRemotelyAsync((Collection<Address>)Collections.singletonList(member), (ReplicableCommand)copy, this.defaultSyncOptions).whenComplete((responseMap, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally((Throwable)throwable);
            } else {
                if (NonTxDistributionInterceptor.getSuccessfulResponseOrFail(responseMap, allFuture, rsp -> allFuture.completeExceptionally((Throwable)((Object)OutdatedTopologyException.INSTANCE))) == null) {
                    return;
                }
                allFuture.countDown();
            }
        });
    }

    private <C extends WriteCommand, Item> Object handleRemoteWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, ?, Item> helper) {
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (ctx.lookupEntry(key) != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        }
        if (helper.shouldRegisterRemoteCallback(command)) {
            return this.invokeNextThenApply(ctx, command, helper.remoteCallback);
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends WriteCommand, Container, Item> Container filterAndWrap(InvocationContext ctx, C command, Set<Integer> segments, WriteManyCommandHelper<C, Container, Item> helper) {
        Container myItems = helper.newContainer();
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (!segments.contains(this.keyPartitioner.getSegment(key))) continue;
            helper.accumulate(myItems, item);
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        }
        return myItems;
    }

    private <C extends WriteCommand, Container, Item> Object handleReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Item, Container> helper) throws Exception {
        ConsistentHash ch = this.checkTopologyId(command).getWriteConsistentHash();
        if (ctx.isOriginLocal()) {
            Map<Address, Set<Integer>> segmentMap = this.primaryOwnersOfSegments(ch);
            Object[] results = null;
            if (!command.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES)) {
                results = new Object[helper.getItems(command).size()];
            }
            MergingCompletableFuture<Object> allFuture = new MergingCompletableFuture<Object>(segmentMap.size(), results, helper::transformResult);
            MutableInt offset = new MutableInt();
            for (Map.Entry<Address, Set<Integer>> pair : segmentMap.entrySet()) {
                Address member = pair.getKey();
                Set<Integer> segments = pair.getValue();
                if (member.equals(this.rpcManager.getAddress())) {
                    this.handleLocalSegmentsForReadWriteManyCommand(ctx, command, helper, ch, allFuture, offset, segments);
                    continue;
                }
                this.handleRemoteSegmentsForReadWriteManyCommand(command, helper, ch, allFuture, offset, member, segments);
            }
            return NonTxDistributionInterceptor.asyncValue(allFuture);
        }
        return this.handleRemoteReadWriteManyCommand(ctx, command, helper);
    }

    private <C extends WriteCommand, Container, Item> void handleLocalSegmentsForReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper, ConsistentHash ch, MergingCompletableFuture<Object> allFuture, MutableInt offset, Set<Integer> segments) throws Exception {
        Container myItems = helper.newContainer();
        List<CompletableFuture<?>> retrievals = null;
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (!segments.contains(this.keyPartitioner.getSegment(key))) continue;
            helper.accumulate(myItems, item);
            retrievals = this.addRemoteGet(ctx, command, retrievals, key);
        }
        int size = helper.containerSize(myItems);
        if (size == 0) {
            allFuture.countDown();
            return;
        }
        int myOffset = offset.value;
        offset.value += size;
        C localCommand = helper.copyForLocal(command, myItems);
        InvocationFinallyAction handler = this.createLocalInvocationHandler(ch, allFuture, segments, helper, MergingCompletableFuture.moveListItemsToFuture(myOffset));
        if (retrievals == null) {
            this.invokeNextAndFinally(ctx, (VisitableCommand)localCommand, handler);
        } else {
            CompletableFuture[] ra = retrievals.toArray(new CompletableFuture[retrievals.size()]);
            Object result = this.asyncInvokeNext(ctx, command, CompletableFuture.allOf(ra));
            NonTxDistributionInterceptor.makeStage(result).andFinally(ctx, command, handler);
        }
    }

    private <C extends WriteCommand, Item> void handleRemoteSegmentsForReadWriteManyCommand(C command, WriteManyCommandHelper<C, ?, Item> helper, ConsistentHash ch, MergingCompletableFuture<Object> allFuture, MutableInt offset, Address member, Set<Integer> segments) {
        int myOffset = offset.value;
        C copy = helper.copyForPrimary(command, ch, segments);
        int size = helper.getItems(copy).size();
        offset.value += size;
        if (size <= 0) {
            allFuture.countDown();
            return;
        }
        this.rpcManager.invokeRemotelyAsync((Collection<Address>)Collections.singletonList(member), (ReplicableCommand)copy, this.defaultSyncOptions).whenComplete((responses, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally((Throwable)throwable);
            } else {
                SuccessfulResponse response = NonTxDistributionInterceptor.getSuccessfulResponseOrFail(responses, allFuture, rsp -> allFuture.completeExceptionally((Throwable)((Object)OutdatedTopologyException.INSTANCE)));
                if (response == null) {
                    return;
                }
                Object responseValue = response.getResponseValue();
                MergingCompletableFuture.moveListItemsToFuture(responseValue, allFuture, myOffset);
                allFuture.countDown();
            }
        });
    }

    private <C extends WriteCommand, Item> Object handleRemoteReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, ?, Item> helper) throws Exception {
        CompletableFuture<Object> delay;
        List<CompletableFuture<?>> retrievals = null;
        for (Item item : helper.getItems(command)) {
            retrievals = this.addRemoteGet(ctx, command, retrievals, helper.item2key(item));
        }
        if (retrievals != null) {
            CompletableFuture[] ra = retrievals.toArray(new CompletableFuture[retrievals.size()]);
            delay = CompletableFuture.allOf(ra);
        } else {
            delay = CompletableFutures.completedNull();
        }
        Object result = this.asyncInvokeNext(ctx, command, delay);
        if (helper.shouldRegisterRemoteCallback(command)) {
            return NonTxDistributionInterceptor.makeStage(result).thenApply(ctx, command, helper.remoteCallback);
        }
        return result;
    }

    private List<CompletableFuture<?>> addRemoteGet(InvocationContext ctx, WriteCommand command, List<CompletableFuture<?>> retrievals, Object key) throws Exception {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (cacheEntry == null) {
            if (command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP) || command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
            } else {
                if (retrievals == null) {
                    retrievals = new ArrayList();
                }
                GetCacheEntryCommand fakeGetCommand = this.cf.buildGetCacheEntryCommand(key, command.getFlagsBitSet());
                CompletableFuture<Void> getFuture = this.remoteGet(ctx, fakeGetCommand, fakeGetCommand.getKey(), true);
                retrievals.add(getFuture);
            }
        }
        return retrievals;
    }

    private <C extends WriteCommand, F extends CountDownCompletableFuture, Item> InvocationFinallyAction createLocalInvocationHandler(ConsistentHash ch, F allFuture, Set<Integer> segments, WriteManyCommandHelper<C, ?, Item> helper, BiConsumer<F, Object> returnValueConsumer) {
        return (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally(throwable);
            } else {
                try {
                    returnValueConsumer.accept(allFuture, rv);
                    Map<Address, Set<Integer>> backupOwners = this.backupOwnersOfSegments(ch, segments);
                    for (Map.Entry<Address, Set<Integer>> backup : backupOwners.entrySet()) {
                        WriteCommand backupCopy = helper.copyForBackup((WriteCommand)rCommand, ch, backup.getValue());
                        if (helper.getItems(backupCopy).isEmpty()) continue;
                        Set<Address> backupOwner = Collections.singleton(backup.getKey());
                        if (this.isSynchronous(backupCopy)) {
                            allFuture.increment();
                            this.rpcManager.invokeRemotelyAsync(backupOwner, backupCopy, this.defaultSyncOptions).whenComplete((responseMap, remoteThrowable) -> {
                                if (remoteThrowable != null) {
                                    allFuture.completeExceptionally((Throwable)remoteThrowable);
                                } else {
                                    allFuture.countDown();
                                }
                            });
                            continue;
                        }
                        this.rpcManager.invokeRemotelyAsync(backupOwner, backupCopy, this.defaultAsyncOptions);
                    }
                    allFuture.countDown();
                }
                catch (Throwable t) {
                    allFuture.completeExceptionally(t);
                }
            }
        };
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private <C extends WriteCommand> Object writeManyRemoteCallback(WriteManyCommandHelper<C, ?, ?> helper, InvocationContext ctx, C command, Object rv) {
        ConsistentHash ch = this.checkTopologyId(command).getWriteConsistentHash();
        Map<Address, Set<Integer>> backups = this.backupOwnersOfSegments(ch, ch.getPrimarySegmentsForOwner(this.rpcManager.getAddress()));
        if (backups.isEmpty()) {
            return rv;
        }
        boolean isSync = this.isSynchronous(command);
        CompletableFuture[] futures = isSync ? new CompletableFuture[backups.size()] : null;
        int future = 0;
        for (Map.Entry<Address, Set<Integer>> backup : backups.entrySet()) {
            C copy = helper.copyForBackup(command, ch, backup.getValue());
            if (isSync) {
                futures[future++] = this.rpcManager.invokeRemotelyAsync((Collection<Address>)Collections.singleton(backup.getKey()), (ReplicableCommand)copy, this.defaultSyncOptions);
                continue;
            }
            this.rpcManager.invokeRemotelyAsync((Collection<Address>)Collections.singleton(backup.getKey()), (ReplicableCommand)copy, this.defaultAsyncOptions);
        }
        return isSync ? NonTxDistributionInterceptor.asyncValue(CompletableFuture.allOf(futures).thenApply(nil -> rv)) : rv;
    }

    private <C extends WriteCommand> InvocationSuccessFunction createRemoteCallback(WriteManyCommandHelper<C, ?, ?> helper) {
        return (ctx, command, rv) -> this.writeManyRemoteCallback(helper, ctx, (WriteCommand)command, rv);
    }

    private static final class MutableInt {
        public int value;

        private MutableInt() {
        }
    }
}

