/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import org.hibernate.search.backend.impl.DeleteByQuerySupport;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.spi.IndexedTypeIdentifier;

public class DeleteByQueryWork
extends Work {
    private final DeletionQuery deleteByQuery;

    public DeleteByQueryWork(IndexedTypeIdentifier entityType, DeletionQuery deletionQuery) {
        this(null, entityType, deletionQuery);
    }

    public DeleteByQueryWork(String tenantId, IndexedTypeIdentifier entityType, DeletionQuery deletionQuery) {
        super(tenantId, entityType, null, WorkType.DELETE_BY_QUERY);
        if (entityType == null) {
            throw new IllegalArgumentException("entityType must not be null");
        }
        if (!DeleteByQuerySupport.isSupported(deletionQuery.getClass())) {
            throw new IllegalArgumentException("unsupported SerializableQuery passed. you can't supply your own custom class here!");
        }
        this.deleteByQuery = deletionQuery;
    }

    public DeletionQuery getDeleteByQuery() {
        return this.deleteByQuery;
    }
}

