/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commons.CacheException;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;

public class InfinispanBatch
implements TransactionBatch {
    private final Transaction tx;
    private volatile boolean rollback = false;
    private final AtomicInteger count = new AtomicInteger(0);

    public InfinispanBatch(Transaction tx) {
        this.tx = tx;
    }

    @Override
    public Transaction getTransaction() {
        return this.tx;
    }

    @Override
    public TransactionBatch interpose() {
        this.count.incrementAndGet();
        return this;
    }

    public void discard() {
        this.rollback = true;
    }

    public void close() {
        if (this.count.getAndDecrement() == 0) {
            try {
                if (this.rollback) {
                    this.tx.rollback();
                } else {
                    this.tx.commit();
                }
            }
            catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                throw new CacheException(e);
            }
        }
    }
}

