/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.EncodingBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public enum NumericFieldBridge implements FieldBridge,
TwoWayFieldBridge,
EncodingBridge,
IgnoreAnalyzerBridge
{
    BYTE_FIELD_BRIDGE{

        @Override
        public Object get(String name, Document document) {
            IndexableField field = document.getField(name);
            return field != null ? Byte.valueOf(field.numericValue().byteValue()) : null;
        }

        @Override
        protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
            super.applyToLuceneOptions(luceneOptions, name, value.intValue(), document);
        }

        @Override
        public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
            return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
        }

        @Override
        public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
            return INT_FIELD_BRIDGE.createNullMarker(indexNullAs);
        }
    }
    ,
    SHORT_FIELD_BRIDGE{

        @Override
        public Object get(String name, Document document) {
            IndexableField field = document.getField(name);
            return field != null ? Short.valueOf(field.numericValue().shortValue()) : null;
        }

        @Override
        protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
            super.applyToLuceneOptions(luceneOptions, name, value.intValue(), document);
        }

        @Override
        public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
            return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
        }

        @Override
        public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
            return INT_FIELD_BRIDGE.createNullMarker(indexNullAs);
        }
    }
    ,
    INT_FIELD_BRIDGE{

        @Override
        public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
            return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
        }

        @Override
        public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
            try {
                return new ToStringNullMarker(Integer.parseInt(indexNullAs));
            }
            catch (NumberFormatException e) {
                throw LOG.invalidNullMarkerForInteger(e);
            }
        }
    }
    ,
    FLOAT_FIELD_BRIDGE{

        @Override
        public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
            return NumericFieldSettingsDescriptor.NumericEncodingType.FLOAT;
        }

        @Override
        public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
            try {
                return new ToStringNullMarker(Float.valueOf(Float.parseFloat(indexNullAs)));
            }
            catch (NumberFormatException e) {
                throw LOG.invalidNullMarkerForFloat(e);
            }
        }
    }
    ,
    DOUBLE_FIELD_BRIDGE{

        @Override
        public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
            return NumericFieldSettingsDescriptor.NumericEncodingType.DOUBLE;
        }

        @Override
        public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
            try {
                return new ToStringNullMarker(Double.parseDouble(indexNullAs));
            }
            catch (NumberFormatException e) {
                throw LOG.invalidNullMarkerForDouble(e);
            }
        }
    }
    ,
    LONG_FIELD_BRIDGE{

        @Override
        public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
            return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
        }

        @Override
        public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
            try {
                return new ToStringNullMarker(Long.parseLong(indexNullAs));
            }
            catch (NumberFormatException e) {
                throw LOG.invalidNullMarkerForLong(e);
            }
        }
    };

    private static final Log LOG;

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            if (luceneOptions.indexNullAs() != null) {
                luceneOptions.addFieldToDocument(name, luceneOptions.indexNullAs(), document);
            }
        } else {
            this.applyToLuceneOptions(luceneOptions, name, (Number)value, document);
        }
    }

    @Override
    public final String objectToString(Object object) {
        return object == null ? null : object.toString();
    }

    @Override
    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        if (field != null) {
            return field.numericValue();
        }
        return null;
    }

    protected void applyToLuceneOptions(LuceneOptions luceneOptions, String name, Number value, Document document) {
        luceneOptions.addNumericFieldToDocument(name, value, document);
    }

    static {
        LOG = LoggerFactory.make(Log.class);
    }
}

