/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.protocols.ssl.ALPNHackSSLEngine;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.SslConnection;

public class JDK8HackALPNClientProvider
implements ALPNClientSelector.ClientSelector {
    @Override
    public void runAlpn(final SslConnection connection, final ChannelListener<SslConnection> fallback, final ClientCallback<ClientConnection> failedListener, ALPNClientSelector.ALPNProtocol ... details) {
        final SslConnection sslConnection = connection;
        SslConduit conduit = UndertowXnioSsl.getSslConduit(sslConnection);
        final ALPNHackSSLEngine sslEngine = new ALPNHackSSLEngine(conduit.getSSLEngine());
        conduit.setSslEngine(sslEngine);
        final HashMap<String, ALPNClientSelector.ALPNProtocol> protocolMap = new HashMap<String, ALPNClientSelector.ALPNProtocol>();
        ArrayList<String> protocols = new ArrayList<String>(details.length);
        for (int i = 0; i < details.length; ++i) {
            protocols.add(details[i].getProtocol());
            protocolMap.put(details[i].getProtocol(), details[i]);
        }
        sslEngine.setApplicationProtocols(protocols);
        try {
            sslConnection.startHandshake();
            sslConnection.getSourceChannel().getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                public void handleEvent(StreamSourceChannel channel) {
                    if (sslEngine.getSelectedApplicationProtocol() != null) {
                        this.handleSelected(sslEngine.getSelectedApplicationProtocol());
                    } else {
                        ByteBuffer buf = ByteBuffer.allocate(100);
                        try {
                            int read = channel.read(buf);
                            if (read > 0) {
                                buf.flip();
                                PushBackStreamSourceConduit pb = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
                                pb.pushBack(new ImmediatePooled<ByteBuffer>(buf));
                                connection.getSourceChannel().setConduit((StreamSourceConduit)pb);
                            } else if (read == -1) {
                                failedListener.failed(new ClosedChannelException());
                            }
                            if (sslEngine.getSelectedApplicationProtocol() != null) {
                                this.handleSelected(sslEngine.getSelectedApplicationProtocol());
                            } else if (read > 0) {
                                sslConnection.getSourceChannel().suspendReads();
                                fallback.handleEvent((Channel)sslConnection);
                                return;
                            }
                        }
                        catch (IOException e) {
                            failedListener.failed(e);
                        }
                    }
                }

                protected void handleSelected(String selected) {
                    if (selected.isEmpty()) {
                        connection.getSourceChannel().suspendReads();
                        fallback.handleEvent((Channel)connection);
                        return;
                    }
                    ALPNClientSelector.ALPNProtocol details = (ALPNClientSelector.ALPNProtocol)protocolMap.get(selected);
                    if (details == null) {
                        connection.getSourceChannel().suspendReads();
                        fallback.handleEvent((Channel)connection);
                        return;
                    }
                    connection.getSourceChannel().suspendReads();
                    details.getSelected().handleEvent((Channel)connection);
                }
            });
            sslConnection.getSourceChannel().resumeReads();
        }
        catch (IOException e) {
            failedListener.failed(e);
        }
        catch (Throwable e) {
            failedListener.failed(new IOException(e));
        }
    }

    @Override
    public boolean isEnabled() {
        return ALPNHackSSLEngine.ENABLED;
    }
}

