/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import org.infinispan.server.core.transport.VInt;
import org.infinispan.server.core.transport.VLong;

public class ExtendedByteBuf {
    private ExtendedByteBuf() {
    }

    public static ByteBuf wrappedBuffer(byte[] ... arrays) {
        return Unpooled.wrappedBuffer((byte[][])arrays);
    }

    public static ByteBuf buffer(int capacity) {
        return Unpooled.buffer((int)capacity);
    }

    public static ByteBuf dynamicBuffer() {
        return Unpooled.buffer();
    }

    public static int readUnsignedShort(ByteBuf bf) {
        return bf.readUnsignedShort();
    }

    public static int readUnsignedInt(ByteBuf bf) {
        return VInt.read(bf);
    }

    public static long readUnsignedLong(ByteBuf bf) {
        return VLong.read(bf);
    }

    public static byte[] readRangedBytes(ByteBuf bf) {
        int length = ExtendedByteBuf.readUnsignedInt(bf);
        return ExtendedByteBuf.readRangedBytes(bf, length);
    }

    public static byte[] readRangedBytes(ByteBuf bf, int length) {
        if (length > 0) {
            byte[] array = new byte[length];
            bf.readBytes(array);
            return array;
        }
        return new byte[0];
    }

    public static String readString(ByteBuf bf) {
        byte[] bytes = ExtendedByteBuf.readRangedBytes(bf);
        return bytes.length > 0 ? new String(bytes, CharsetUtil.UTF_8) : "";
    }

    public static void writeUnsignedShort(int i, ByteBuf bf) {
        bf.writeShort(i);
    }

    public static void writeUnsignedInt(int i, ByteBuf bf) {
        VInt.write(bf, i);
    }

    public static void writeUnsignedLong(long l, ByteBuf bf) {
        VLong.write(bf, l);
    }

    public static void writeRangedBytes(byte[] src, ByteBuf bf) {
        ExtendedByteBuf.writeUnsignedInt(src.length, bf);
        if (src.length > 0) {
            bf.writeBytes(src);
        }
    }

    public static void writeString(String msg, ByteBuf bf) {
        ExtendedByteBuf.writeRangedBytes(msg.getBytes(CharsetUtil.UTF_8), bf);
    }
}

