/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.work.impl.BulkResult;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.exception.AssertionFailure;

class DefaultElasticsearchWorkBulker
implements ElasticsearchWorkBulker {
    private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
    private final Function<List<BulkableElasticsearchWork<?>>, ElasticsearchWork<BulkResult>> bulkWorkFactory;
    private final int minBulkSize;
    private final int maxBulkSize;
    private final List<BulkableElasticsearchWork<?>> currentBulkWorks;
    private int currentBulkFirstUnflushedWork;
    private CompletableFuture<ElasticsearchWork<BulkResult>> currentBulkWorkFuture;
    private CompletableFuture<BulkResult> currentBulkResultFuture;

    public DefaultElasticsearchWorkBulker(ElasticsearchWorkSequenceBuilder sequenceBuilder, Function<List<BulkableElasticsearchWork<?>>, ElasticsearchWork<BulkResult>> bulkWorkFactory, int minBulkSize, int maxBulkSize) {
        this.sequenceBuilder = sequenceBuilder;
        this.bulkWorkFactory = bulkWorkFactory;
        this.minBulkSize = minBulkSize;
        this.maxBulkSize = maxBulkSize;
        this.currentBulkWorks = new ArrayList();
        this.currentBulkFirstUnflushedWork = 0;
        this.currentBulkWorkFuture = null;
        this.currentBulkResultFuture = null;
    }

    @Override
    public void add(BulkableElasticsearchWork<?> work) {
        this.currentBulkWorks.add(work);
        if (this.currentBulkWorks.size() >= this.maxBulkSize) {
            this.flushBulked();
            this.flushBulk();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean flushBulked() {
        void var3_6;
        int currentBulkWorksSize = this.currentBulkWorks.size();
        if (currentBulkWorksSize <= this.currentBulkFirstUnflushedWork) {
            return false;
        }
        if (currentBulkWorksSize < this.minBulkSize && this.currentBulkFirstUnflushedWork == 0) {
            for (ElasticsearchWork elasticsearchWork : this.currentBulkWorks) {
                this.sequenceBuilder.addNonBulkExecution(elasticsearchWork);
            }
            this.reset();
            return false;
        }
        if (this.currentBulkWorkFuture == null) {
            this.currentBulkWorkFuture = new CompletableFuture();
            this.currentBulkResultFuture = this.sequenceBuilder.addBulkExecution(this.currentBulkWorkFuture);
        }
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = this.sequenceBuilder.startBulkResultExtraction(this.currentBulkResultFuture);
        int n = this.currentBulkFirstUnflushedWork;
        while (var3_6 < currentBulkWorksSize) {
            void bulkedWorkIndex = var3_6++;
            BulkableElasticsearchWork<?> bulkedWork = this.currentBulkWorks.get((int)bulkedWorkIndex);
            extractionStep.add(bulkedWork, (int)bulkedWorkIndex);
        }
        this.currentBulkFirstUnflushedWork = currentBulkWorksSize;
        return true;
    }

    @Override
    public void flushBulk() {
        if (this.currentBulkWorks.size() != this.currentBulkFirstUnflushedWork) {
            throw new AssertionFailure("Some works haven't been flushed to the sequence builder");
        }
        if (this.currentBulkWorkFuture == null) {
            return;
        }
        ElasticsearchWork<BulkResult> bulkWork = this.bulkWorkFactory.apply(this.currentBulkWorks);
        this.currentBulkWorkFuture.complete(bulkWork);
        this.reset();
    }

    @Override
    public void reset() {
        this.currentBulkWorks.clear();
        this.currentBulkFirstUnflushedWork = 0;
        this.currentBulkWorkFuture = null;
        this.currentBulkResultFuture = null;
    }
}

