/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.BarrierElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.processor.impl.BatchingSharedElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.processor.impl.DefaultContextualErrorHandler;
import org.hibernate.search.elasticsearch.processor.impl.DefaultElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.DefaultElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkBulker;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.processor.impl.ImmutableElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.processor.impl.IndexMonitorBufferingElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.processor.impl.ParallelChangesetsElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.processor.impl.RefreshingElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.processor.impl.SerialChangesetsElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.Throwables;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchWorkProcessor
implements AutoCloseable {
    private static final int NON_STREAM_MIN_BULK_SIZE = 2;
    private static final int STREAM_MIN_BULK_SIZE = 1;
    private static final int MAX_BULK_SIZE = 250;
    private static final int NON_STREAM_MAX_CHANGESETS_PER_BATCH = 2500;
    private static final int STREAM_MAX_CHANGESETS_PER_BATCH = 5000;
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final ErrorHandler errorHandler;
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkExecutionContext parallelWorkExecutionContext;
    private final BarrierElasticsearchWorkOrchestrator streamOrchestrator;

    public ElasticsearchWorkProcessor(BuildContext context, ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkFactory workFactory) {
        this.errorHandler = context.getErrorHandler();
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.workFactory = workFactory;
        this.parallelWorkExecutionContext = new ImmutableElasticsearchWorkExecutionContext(client, gsonProvider);
        this.streamOrchestrator = this.createBatchingSharedOrchestrator("Elasticsearch async stream work orchestrator", 5000, false, this.createParallelOrchestrator(this::createIndexMonitorBufferingWorkExecutionContext, 1, false));
    }

    @Override
    public void close() {
        try {
            this.streamOrchestrator.awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw LOG.interruptedWhileWaitingForRequestCompletion(e);
        }
        finally {
            this.streamOrchestrator.close();
        }
    }

    public <T> T executeSyncUnsafe(ElasticsearchWork<T> work) {
        try {
            return this.executeAsyncUnsafe(work).join();
        }
        catch (CompletionException e) {
            throw Throwables.expectRuntimeException((Throwable)e.getCause());
        }
    }

    public <T> CompletableFuture<T> executeAsyncUnsafe(ElasticsearchWork<T> work) {
        return this.start(work, this.parallelWorkExecutionContext);
    }

    public BarrierElasticsearchWorkOrchestrator createNonStreamOrchestrator(String indexName, boolean refreshAfterWrite) {
        boolean refreshInBulkApiCall;
        Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplier;
        if (refreshAfterWrite) {
            contextSupplier = this::createRefreshingWorkExecutionContext;
            refreshInBulkApiCall = true;
        } else {
            contextSupplier = this::createIndexMonitorBufferingWorkExecutionContext;
            refreshInBulkApiCall = false;
        }
        FlushableElasticsearchWorkOrchestrator delegate = this.createSerialOrchestrator(contextSupplier, 2, refreshInBulkApiCall);
        return this.createBatchingSharedOrchestrator("Elasticsearch non-stream work orchestrator for index " + indexName, 2500, true, delegate);
    }

    public BarrierElasticsearchWorkOrchestrator getStreamOrchestrator() {
        return this.streamOrchestrator;
    }

    private <T> CompletableFuture<T> start(ElasticsearchWork<T> work, ElasticsearchWorkExecutionContext context) {
        LOG.tracef("Processing %s", work);
        return work.execute(context);
    }

    private BatchingSharedElasticsearchWorkOrchestrator createBatchingSharedOrchestrator(String name, int maxChangesetsPerBatch, boolean fair, FlushableElasticsearchWorkOrchestrator delegate) {
        return new BatchingSharedElasticsearchWorkOrchestrator(name, maxChangesetsPerBatch, fair, delegate, this.errorHandler);
    }

    private FlushableElasticsearchWorkOrchestrator createSerialOrchestrator(Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplier, int minBulkSize, boolean refreshInBulkAPICall) {
        ElasticsearchWorkSequenceBuilder sequenceBuilder = this.createSequenceBuilder(contextSupplier);
        ElasticsearchWorkBulker bulker = this.createBulker(sequenceBuilder, minBulkSize, refreshInBulkAPICall);
        return new SerialChangesetsElasticsearchWorkOrchestrator(sequenceBuilder, bulker);
    }

    private FlushableElasticsearchWorkOrchestrator createParallelOrchestrator(Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplier, int minBulkSize, boolean refreshInBulkAPICall) {
        ElasticsearchWorkSequenceBuilder sequenceBuilder = this.createSequenceBuilder(contextSupplier);
        ElasticsearchWorkBulker bulker = this.createBulker(sequenceBuilder, minBulkSize, refreshInBulkAPICall);
        return new ParallelChangesetsElasticsearchWorkOrchestrator(sequenceBuilder, bulker);
    }

    private ElasticsearchWorkSequenceBuilder createSequenceBuilder(Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplier) {
        return new DefaultElasticsearchWorkSequenceBuilder(this::start, contextSupplier, () -> new DefaultContextualErrorHandler(this.errorHandler));
    }

    private ElasticsearchWorkBulker createBulker(ElasticsearchWorkSequenceBuilder sequenceBuilder, int minBulkSize, boolean refreshInBulkAPICall) {
        return new DefaultElasticsearchWorkBulker(sequenceBuilder, worksToBulk -> this.workFactory.bulk((List<BulkableElasticsearchWork<?>>)worksToBulk).refresh(refreshInBulkAPICall).build(), minBulkSize, 250);
    }

    private FlushableElasticsearchWorkExecutionContext createIndexMonitorBufferingWorkExecutionContext() {
        return new IndexMonitorBufferingElasticsearchWorkExecutionContext(this.client, this.gsonProvider, this.errorHandler);
    }

    private FlushableElasticsearchWorkExecutionContext createRefreshingWorkExecutionContext() {
        return new RefreshingElasticsearchWorkExecutionContext(this.client, this.gsonProvider, this.workFactory, this, this.errorHandler);
    }
}

