/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.filter.ElasticsearchFilter;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.query.impl.ElasticsearchScrollAPIDocumentExtractor;
import org.hibernate.search.elasticsearch.query.impl.EmptyDocumentExtractor;
import org.hibernate.search.elasticsearch.query.impl.EmptySearchResult;
import org.hibernate.search.elasticsearch.query.impl.IndexSearcher;
import org.hibernate.search.elasticsearch.query.impl.QueryHitConverter;
import org.hibernate.search.elasticsearch.work.impl.ExplainResult;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.engine.impl.AbstractHSQuery;
import org.hibernate.search.query.engine.impl.FacetComparators;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchHSQueryImpl
extends AbstractHSQuery {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final Set<String> SUPPORTED_PROJECTION_CONSTANTS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{"__HSearch_id", "_hibernate_class", "__HSearch_Score", "__HSearch_Source", "_HSearch_SpatialDistance", "__HSearch_This", "__HSearch_Took", "__HSearch_TimedOut"}));
    final JsonObject rawSearchPayload;
    private Integer resultSize;
    private IndexSearcher searcher;
    private SearchResult searchResult;
    private transient FacetManagerImpl facetManager;

    public ElasticsearchHSQueryImpl(JsonObject rawSearchPayload, ExtendedSearchIntegrator extendedIntegrator, IndexedTypeSet types) {
        super(extendedIntegrator, types);
        this.rawSearchPayload = rawSearchPayload;
    }

    public ElasticsearchHSQueryImpl(JsonObject rawSearchPayload, ExtendedSearchIntegrator extendedIntegrator, IndexedTypeMap<CustomTypeMetadata> types) {
        super(extendedIntegrator, types);
        this.rawSearchPayload = rawSearchPayload;
    }

    public HSQuery luceneQuery(Query query) {
        throw LOG.hsQueryLuceneQueryUnsupported();
    }

    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl((AbstractHSQuery)this);
        }
        return this.facetManager;
    }

    public Query getLuceneQuery() {
        throw LOG.hsQueryLuceneQueryUnsupported();
    }

    public String getQueryString() {
        return this.rawSearchPayload.toString();
    }

    public DocumentExtractor queryDocumentExtractor() {
        IndexSearcher searcher = this.getOrCreateSearcher();
        if (searcher != null) {
            return new ElasticsearchScrollAPIDocumentExtractor(searcher, this.firstResult, this.maxResults);
        }
        return EmptyDocumentExtractor.get();
    }

    SearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.execute();
        }
        return this.searchResult;
    }

    public int queryResultSize() {
        if (this.searchResult == null) {
            this.execute();
        }
        return this.resultSize;
    }

    public Explanation explain(int documentId) {
        if (this.searchResult == null) {
            this.execute();
        }
        JsonObject hit = this.searchResult.getHits().get(documentId).getAsJsonObject();
        ExplainResult result = this.searcher.explain(hit);
        JsonObject explanation = result.getJsonObject().get("explanation").getAsJsonObject();
        return this.convertExplanation(explanation);
    }

    private Explanation convertExplanation(JsonObject explanation) {
        List details;
        float value = explanation.get("value").getAsFloat();
        String description = explanation.get("description").getAsString();
        JsonElement explanationDetails = explanation.get("details");
        if (explanationDetails != null) {
            details = new ArrayList(explanationDetails.getAsJsonArray().size());
            for (JsonElement detail : explanationDetails.getAsJsonArray()) {
                details.add(this.convertExplanation(detail.getAsJsonObject()));
            }
        } else {
            details = Collections.emptyList();
        }
        return Explanation.match((float)value, (String)description, details);
    }

    protected void clearCachedResults() {
        this.searcher = null;
        this.searchResult = null;
        this.resultSize = null;
    }

    protected TimeoutManagerImpl buildTimeoutManager() {
        return new TimeoutManagerImpl((Object)this.rawSearchPayload, this.timeoutExceptionFactory, this.extendedIntegrator.getTimingSource());
    }

    public List<EntityInfo> queryEntityInfos() {
        if (this.searchResult == null) {
            this.execute();
        }
        JsonArray hits = this.searchResult.getHits();
        ArrayList<EntityInfo> results = new ArrayList<EntityInfo>(hits.size());
        for (JsonElement hit : hits) {
            EntityInfo entityInfo = this.searcher.convertQueryHit(this.searchResult, hit.getAsJsonObject());
            if (entityInfo == null) continue;
            results.add(entityInfo);
        }
        return results;
    }

    protected Set<String> getSupportedProjectionConstants() {
        return SUPPORTED_PROJECTION_CONSTANTS;
    }

    protected Set<IndexManager> getIndexManagers(EntityIndexBinding binding) {
        Set indexManagers = super.getIndexManagers(binding);
        for (IndexManager indexManager : indexManagers) {
            if (indexManager instanceof ElasticsearchIndexManager) continue;
            throw LOG.cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(binding.getDocumentBuilder().getTypeIdentifier(), this.rawSearchPayload.toString());
        }
        return indexManagers;
    }

    private void execute() {
        IndexSearcher searcher = this.getOrCreateSearcher();
        this.searchResult = searcher != null ? searcher.search(this.firstResult, this.maxResults) : EmptySearchResult.get();
        this.resultSize = this.searchResult.getTotalHitCount();
    }

    private IndexSearcher getOrCreateSearcher() {
        if (this.searcher != null) {
            return this.searcher;
        }
        ElasticsearchService elasticsearchService = null;
        Map targetedEntityBindingsByName = this.buildTargetedEntityIndexBindingsByName();
        HashSet<URLEncodedString> indexNames = new HashSet<URLEncodedString>();
        for (Map.Entry entry : targetedEntityBindingsByName.entrySet()) {
            EntityIndexBinding binding = (EntityIndexBinding)entry.getValue();
            Set<IndexManager> indexManagers = this.getIndexManagers(binding);
            for (IndexManager indexManager : indexManagers) {
                ElasticsearchIndexManager esIndexManager = (ElasticsearchIndexManager)indexManager;
                indexNames.add(URLEncodedString.fromString(esIndexManager.getActualIndexName()));
                if (elasticsearchService == null) {
                    elasticsearchService = esIndexManager.getElasticsearchService();
                    continue;
                }
                if (elasticsearchService == esIndexManager.getElasticsearchService()) continue;
                throw new AssertionFailure("Found two index managers refering to two different ElasticsearchService instances");
            }
        }
        if (indexNames.isEmpty()) {
            return null;
        }
        Collection facetingRequests = this.getFacetManager().getFacetRequests().values();
        Map facetingRequestsAndMetadata = this.buildFacetingRequestsAndMetadata(facetingRequests, targetedEntityBindingsByName.values());
        if (this.sort != null) {
            this.validateSortFields(targetedEntityBindingsByName.values());
        }
        JsonObject filteredQuery = this.getFilteredQuery(this.rawSearchPayload.get("query"), targetedEntityBindingsByName.keySet());
        Integer sortByDistanceIndex = this.getSortByDistanceIndex();
        QueryHitConverter queryHitConverter = QueryHitConverter.builder(elasticsearchService.getQueryFactory(), targetedEntityBindingsByName).setProjectedFields(this.projectedFields).setSortByDistance(sortByDistanceIndex, this.spatialSearchCenter, this.spatialFieldName).build();
        this.searcher = new IndexSearcher(elasticsearchService, targetedEntityBindingsByName, indexNames, filteredQuery, queryHitConverter, this.sort, facetingRequestsAndMetadata);
        return this.searcher;
    }

    private JsonObject getFilteredQuery(JsonElement originalQuery, Set<String> typeNames) {
        JsonArray filters = new JsonArray();
        JsonObject tenantFilter = this.getTenantIdFilter();
        if (tenantFilter != null) {
            filters.add((JsonElement)tenantFilter);
        }
        JsonArray typeFilters = new JsonArray();
        for (String typeName : typeNames) {
            typeFilters.add((JsonElement)this.getEntityTypeFilter(typeName));
        }
        filters.add((JsonElement)ToElasticsearch.condition("should", typeFilters));
        for (Query query : this.getFacetManager().getFacetFilters().getFilterQueries()) {
            filters.add((JsonElement)ToElasticsearch.fromLuceneQuery(query));
        }
        if (this.userFilter != null) {
            filters.add((JsonElement)ToElasticsearch.fromLuceneQuery((Query)this.userFilter));
        }
        if (!this.filterDefinitions.isEmpty()) {
            for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
                JsonObject filter = this.buildFullTextFilter(fullTextFilter);
                if (filter == null) continue;
                filters.add((JsonElement)filter);
            }
        }
        JsonBuilder.Object boolBuilder = JsonBuilder.object();
        if (originalQuery != null && !originalQuery.isJsonNull()) {
            boolBuilder.add("must", originalQuery);
        }
        if (filters.size() == 1) {
            boolBuilder.add("filter", filters.get(0));
        } else {
            boolBuilder.add("filter", (JsonElement)filters);
        }
        return JsonBuilder.object().add("bool", (JsonElement)boolBuilder.build()).build();
    }

    private JsonObject getEntityTypeFilter(String name) {
        JsonObject value = new JsonObject();
        value.addProperty("value", name);
        JsonObject type = new JsonObject();
        type.add("type", (JsonElement)value);
        return type;
    }

    private JsonObject getTenantIdFilter() {
        if (this.tenantId == null) {
            return null;
        }
        JsonObject value = new JsonObject();
        value.addProperty("__HSearch_TenantId", this.tenantId);
        JsonObject tenantFilter = new JsonObject();
        tenantFilter.add("term", (JsonElement)value);
        return tenantFilter;
    }

    private Integer getSortByDistanceIndex() {
        int i = 0;
        if (this.sort != null) {
            for (SortField sortField : this.sort.getSort()) {
                if (sortField instanceof DistanceSortField) {
                    return i;
                }
                ++i;
            }
        }
        return null;
    }

    protected void extractFacetResults() {
        SearchResult searchResult = this.getSearchResult();
        JsonObject aggregations = searchResult.getAggregations();
        if (aggregations == null) {
            return;
        }
        HashMap<String, List<Facet>> results = new HashMap<String, List<Facet>>();
        for (Map.Entry<FacetingRequest, FacetMetadata> entry : this.searcher.getFacetingRequestsAndMetadata().entrySet()) {
            List<Facet> facets;
            FacetingRequest facetRequest = entry.getKey();
            FacetMetadata facetMetadata = entry.getValue();
            if (facetRequest instanceof DiscreteFacetRequest) {
                facets = this.extractDiscreteFacets(aggregations, (DiscreteFacetRequest)facetRequest, facetMetadata);
            } else {
                facets = this.extractRangeFacets(aggregations, (RangeFacetRequest)facetRequest, facetMetadata);
                if (!FacetSortOrder.RANGE_DEFINITION_ORDER.equals((Object)facetRequest.getSort())) {
                    Collections.sort(facets, FacetComparators.get((FacetSortOrder)facetRequest.getSort()));
                }
            }
            results.put(facetRequest.getFacetingName(), facets);
        }
        this.getFacetManager().setFacetResults(results);
    }

    private List<Facet> extractRangeFacets(JsonObject aggregations, RangeFacetRequest<?> facetRequest, FacetMetadata facetMetadata) {
        if (!(ReflectionHelper.isIntegerType((Class)facetRequest.getFacetValueType()) || Date.class.isAssignableFrom(facetRequest.getFacetValueType()) || ReflectionHelper.isFloatingPointType((Class)facetRequest.getFacetValueType()))) {
            throw LOG.unsupportedFacetRangeParameter(facetRequest.getFacetValueType().getName());
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (FacetRange facetRange : facetRequest.getFacetRangeList()) {
            int docCount;
            JsonElement aggregation = aggregations.get(facetRequest.getFacetingName() + "-" + facetRange.getIdentifier());
            if (aggregation == null || (docCount = aggregation.getAsJsonObject().get("doc_count").getAsInt()) == 0 && !facetRequest.hasZeroCountsIncluded()) continue;
            facets.add(facetRequest.createFacet(facetMetadata, facetRange.getRangeString(), docCount));
        }
        return facets;
    }

    private List<Facet> extractDiscreteFacets(JsonObject aggregations, DiscreteFacetRequest facetRequest, FacetMetadata facetMetadata) {
        JsonElement aggregation = aggregations.get(facetRequest.getFacetingName());
        if (aggregation == null) {
            return Collections.emptyList();
        }
        if (this.isNested(facetRequest)) {
            aggregation = aggregation.getAsJsonObject().get(facetRequest.getFacetingName());
        }
        if (aggregation == null) {
            return Collections.emptyList();
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (JsonElement bucket : aggregation.getAsJsonObject().get("buckets").getAsJsonArray()) {
            facets.add(facetRequest.createFacet(facetMetadata, bucket.getAsJsonObject().get("key").getAsString(), bucket.getAsJsonObject().get("doc_count").getAsInt()));
        }
        return facets;
    }

    JsonObject buildFullTextFilter(FullTextFilterImpl fullTextFilter) {
        FilterDef def = this.extendedIntegrator.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        Object filterOrFactory = this.createFilterInstance(fullTextFilter, def);
        return this.createFullTextFilter(def, filterOrFactory);
    }

    protected JsonObject createFullTextFilter(FilterDef def, Object filterOrFactory) {
        JsonObject jsonFilter;
        block5: {
            if (def.getFactoryMethod() != null) {
                try {
                    Object candidateFilter = def.getFactoryMethod().invoke(filterOrFactory, new Object[0]);
                    jsonFilter = this.toJsonFilter(candidateFilter);
                    if (jsonFilter == null) {
                        throw LOG.filterFactoryMethodReturnsUnsupportedType(def.getImpl().getName(), def.getFactoryMethod().getName());
                    }
                    break block5;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw LOG.filterFactoryMethodInaccessible(def.getImpl().getName(), def.getFactoryMethod().getName(), e);
                }
            }
            jsonFilter = this.toJsonFilter(filterOrFactory);
            if (jsonFilter == null) {
                throw LOG.filterHasUnsupportedType(filterOrFactory == null ? null : filterOrFactory.getClass().getName());
            }
        }
        return jsonFilter;
    }

    private JsonObject toJsonFilter(Object candidateFilter) {
        if (candidateFilter instanceof Query) {
            return ToElasticsearch.fromLuceneQuery((Query)candidateFilter);
        }
        if (candidateFilter instanceof ElasticsearchFilter) {
            return JSON_PARSER.parse(((ElasticsearchFilter)candidateFilter).getJsonFilter()).getAsJsonObject();
        }
        return null;
    }

    private boolean isNested(DiscreteFacetRequest facetRequest) {
        return false;
    }
}

