/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.query.impl.FieldProjection;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class JsonDrivenProjection
extends FieldProjection {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final String absoluteName;

    public JsonDrivenProjection(String absoluteName) {
        this.absoluteName = absoluteName;
    }

    @Override
    public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
        JsonElement value = this.extractFieldValue(hit.get("_source").getAsJsonObject(), this.absoluteName);
        if (value == null || value.isJsonNull()) {
            return null;
        }
        if (!value.isJsonPrimitive()) {
            throw LOG.unsupportedProjectionOfNonJsonPrimitiveFields(value);
        }
        JsonPrimitive primitive = value.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        return primitive.toString();
    }
}

