/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.hibernate.search.elasticsearch.spi.DigestSelfSigningCapable;
import org.hibernate.search.elasticsearch.util.impl.ProgressiveCharBufferWriter;
import org.hibernate.search.exception.SearchException;

public final class GsonHttpEntity
implements HttpEntity,
HttpAsyncContentProducer,
DigestSelfSigningCapable {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final byte[] NEWLINE = "\n".getBytes(CHARSET);
    private static final BasicHeader CONTENT_TYPE = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
    private static final int BYTE_BUFFER_PAGE_SIZE = 1024;
    private static final int CHAR_BUFFER_SIZE = 1024;
    private final Gson gson;
    private final List<JsonObject> bodyParts;
    private long contentLength;
    private boolean contentlengthWasProvided = false;
    private int nextBodyToEncodeIndex = 0;
    private ProgressiveCharBufferWriter writer = new ProgressiveCharBufferWriter(CHARSET, 1024, 1024);

    public GsonHttpEntity(Gson gson, List<JsonObject> bodyParts) {
        Objects.requireNonNull(gson);
        Objects.requireNonNull(bodyParts);
        this.gson = gson;
        this.bodyParts = bodyParts;
        this.contentLength = -1L;
        this.attemptOnePassEncoding();
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        this.contentlengthWasProvided = true;
        return this.contentLength;
    }

    public Header getContentType() {
        return CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException("Not implemented! Expected to produce content only over produceContent()");
    }

    public void writeTo(OutputStream outstream) throws IOException {
        throw new UnsupportedOperationException("Not implemented! Expected to produce content only over produceContent()");
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() throws IOException {
    }

    public void close() throws IOException {
        this.nextBodyToEncodeIndex = 0;
        this.writer = new ProgressiveCharBufferWriter(CHARSET, 1024, 1024);
    }

    private void attemptOnePassEncoding() {
        try {
            this.triggerFullWrite();
            if (this.nextBodyToEncodeIndex == this.bodyParts.size()) {
                this.writer.flush();
                this.hintContentLength(this.writer.byteBufferContentSize());
            }
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }

    private void triggerFullWrite() throws IOException {
        while (this.nextBodyToEncodeIndex < this.bodyParts.size()) {
            JsonObject bodyPart = this.bodyParts.get(this.nextBodyToEncodeIndex++);
            this.gson.toJson((JsonElement)bodyPart, (Appendable)this.writer);
            this.writer.append('\n');
            this.writer.flush();
            if (!this.writer.isFlowControlPushingBack()) continue;
            return;
        }
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        Objects.requireNonNull(encoder);
        this.writer.setOutput(encoder);
        this.writer.resumePendingWrites();
        if (this.writer.isFlowControlPushingBack()) {
            return;
        }
        this.triggerFullWrite();
        if (this.writer.isFlowControlPushingBack()) {
            return;
        }
        this.writer.flushToOutput();
        if (this.writer.isFlowControlPushingBack()) {
            return;
        }
        encoder.complete();
        this.nextBodyToEncodeIndex = 0;
    }

    @Override
    public void fillDigest(MessageDigest digest) throws IOException {
        DigestWriter digestWriter = new DigestWriter(digest);
        for (JsonObject bodyPart : this.bodyParts) {
            this.gson.toJson((JsonElement)bodyPart, (Appendable)digestWriter);
            digestWriter.insertNewline();
        }
        this.hintContentLength(digestWriter.getContentLength());
    }

    private void hintContentLength(long contentLength) {
        if (!this.contentlengthWasProvided) {
            this.contentLength = contentLength;
        }
    }

    private static final class DigestWriter
    extends Writer {
        private final MessageDigest digest;
        private long totalWrittenBytes = 0L;

        public DigestWriter(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(char[] input, int offset, int len) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(input, offset, len);
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
            this.totalWrittenBytes += (long)byteBuffer.remaining();
            this.digest.update(byteBuffer);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public void insertNewline() {
            this.totalWrittenBytes += (long)NEWLINE.length;
            this.digest.update(NEWLINE);
        }

        public long getContentLength() {
            return this.totalWrittenBytes;
        }
    }
}

