/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.result.JsonResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.CodecAwareStatement;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Option;

public class GetStatement
extends CodecAwareStatement {
    final KeyData keyData;

    public GetStatement(List<Option> options, KeyData key) {
        super(options);
        this.keyData = key;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Cache cache = session.getCache(this.keyData.getCacheName());
        Object key = this.keyData.key;
        Codec codec = this.getCodec(session);
        Object value = cache.get(codec.encodeKey(key));
        if (value == null) {
            return new StringResult("null");
        }
        Object decoded = codec.decodeValue(value);
        if (decoded instanceof String) {
            return new StringResult((String)decoded);
        }
        if (decoded.getClass().isPrimitive()) {
            return new StringResult(decoded.toString());
        }
        return new JsonResult(decoded);
    }
}

