/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.resolution.CovariantTypes;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.util.reflection.Reflections;

public class Types {
    public static final Function<Type, Class<?>> TYPE_TO_CLASS_FUNCTION = new Function<Type, Class<?>>(){

        public Class<?> apply(Type input) {
            return Reflections.getRawType(input);
        }
    };

    private Types() {
    }

    public static Type boxedType(Type type) {
        if (type instanceof Class) {
            return Types.boxedClass((Class)type);
        }
        return type;
    }

    public static Class<?> boxedClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        return type;
    }

    public static String getTypeId(Type type) {
        if (type instanceof Class) {
            return ((Class)Reflections.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder(Types.getTypeId(pt.getRawType()));
            builder.append("<");
            for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(Types.getTypeId(pt.getActualTypeArguments()[i]));
            }
            builder.append(">");
            return builder.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            StringBuilder builder = new StringBuilder(Types.getTypeId(arrayType.getGenericComponentType()));
            builder.append("[]");
            return builder.toString();
        }
        throw new IllegalArgumentException("Cannot create type id for " + type.toString());
    }

    public static Type getCanonicalType(Class<?> clazz) {
        Type resolvedComponentType;
        Class<?> componentType;
        if (clazz.isArray() && (componentType = clazz.getComponentType()) != (resolvedComponentType = Types.getCanonicalType(componentType))) {
            return new GenericArrayTypeImpl(resolvedComponentType);
        }
        if (clazz.getTypeParameters().length > 0) {
            Type[] actualTypeParameters = clazz.getTypeParameters();
            return new ParameterizedTypeImpl((Type)clazz, actualTypeParameters, (Type)clazz.getDeclaringClass());
        }
        return clazz;
    }

    public static Type getCanonicalType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return Types.getCanonicalType(clazz);
        }
        return type;
    }

    public static boolean containsUnresolvedTypeVariableOrWildcard(Type type) {
        if ((type = Types.getCanonicalType(type)) instanceof TypeVariable || type instanceof WildcardType) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (!Types.containsUnresolvedTypeVariableOrWildcard(t)) continue;
                return true;
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Types.containsUnresolvedTypeVariableOrWildcard(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    public static boolean containsTypeVariable(Type type) {
        if ((type = Types.getCanonicalType(type)) instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (!Types.containsTypeVariable(t)) continue;
                return true;
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Types.containsTypeVariable(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    public static Set<Class<?>> getRawTypes(Set<Type> types) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(types, TYPE_TO_CLASS_FUNCTION));
    }

    public static Class<?>[] getRawTypes(Type[] types) {
        if (types.length == 0) {
            return Arrays2.EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = (Class)TYPE_TO_CLASS_FUNCTION.apply((Object)types[i]);
        }
        return result;
    }

    public static <C extends Class<?>> Map<String, C> buildClassNameMap(Iterable<C> set) {
        HashMap<String, Class> loadedStereotypes = new HashMap<String, Class>();
        for (Class javaClass : set) {
            loadedStereotypes.put(javaClass.getName(), javaClass);
        }
        return loadedStereotypes;
    }

    public static boolean isActualType(Type type) {
        return type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType;
    }

    public static boolean isArray(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static Type getArrayComponentType(Type type) {
        Class clazz;
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType();
        }
        if (type instanceof Class && (clazz = (Class)type).isArray()) {
            return clazz.getComponentType();
        }
        throw new IllegalArgumentException("Not an array type " + type);
    }

    public static boolean isArrayOfUnboundedTypeVariablesOrObjects(Type[] types) {
        for (Type type : types) {
            Type[] bounds;
            if (Object.class.equals((Object)type) || type instanceof TypeVariable && ((bounds = ((TypeVariable)type).getBounds()) == null || bounds.length == 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRawGenericType(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return Types.isRawGenericType(componentType);
        }
        return clazz.getTypeParameters().length > 0;
    }

    public static boolean isIllegalBeanType(Type beanType) {
        boolean result = false;
        if (beanType instanceof TypeVariable) {
            result = true;
        } else if (beanType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)beanType;
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (typeArgument instanceof TypeVariable || !(typeArgument instanceof WildcardType) && !Types.isIllegalBeanType(typeArgument)) continue;
                result = true;
                break;
            }
        } else if (beanType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)beanType;
            result = Types.isIllegalBeanType(arrayType.getGenericComponentType());
        }
        return result;
    }

    public static boolean isMoreSpecific(Type type1, Type type2) {
        if (type1.equals(type2)) {
            return false;
        }
        return CovariantTypes.isAssignableFrom(type2, type1);
    }
}

