/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import java.util.concurrent.TimeUnit;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RestAccessLoggingHandler {
    private static final Log log = (Log)LogFactory.getLog(RestAccessLoggingHandler.class, Log.class);
    private static final String NANO_TIME = "NanoTime";

    private boolean isEnabled() {
        return log.isTraceEnabled();
    }

    public void log(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        if (this.isEnabled()) {
            String remoteAddress = ctx.channel().remoteAddress().toString();
            String timeString = request.headers().getAsString((CharSequence)NANO_TIME);
            long startNano = timeString != null ? Long.parseLong(timeString) : 0L;
            String requestMethod = request.method().toString();
            String uri = request.uri();
            int status = response.status().code();
            int requestSize = request.content().readableBytes();
            int responseSize = response.content().readableBytes();
            long responseTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNano);
            log.tracef("%s [%s] \"%s %s\" %s %d %d %d ms", new Object[]{remoteAddress, responseTime, requestMethod, uri, status, requestSize, responseSize, responseTime});
        }
    }
}

