/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.InfinispanCacheResponse;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.operations.exceptions.ServerInternalException;

public class StaticContent {
    private static final URL HTML_FILE = StaticContent.class.getClassLoader().getResource("index.html");
    private static final URL BANNER_FILE = StaticContent.class.getClassLoader().getResource("banner.png");

    public InfinispanResponse serveHtmlFile(InfinispanRequest request) throws ServerInternalException {
        InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
        try {
            response.contentAsBytes(this.loadFile(HTML_FILE));
            response.contentType(MediaType.TEXT_HTML.toString());
            response.status(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            throw new ServerInternalException(e);
        }
        return response;
    }

    public InfinispanResponse serveBannerFile(InfinispanRequest request) throws ServerInternalException {
        InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
        try {
            response.contentAsBytes(this.loadFile(BANNER_FILE));
            response.contentType(MediaType.IMAGE_PNG.toString());
            response.status(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            throw new ServerInternalException(e);
        }
        return response;
    }

    /*
     * Loose catch block
     */
    private byte[] loadFile(URL url) throws IOException, URISyntaxException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            try (InputStream is = url.openStream();){
                int nRead;
                byte[] data = new byte[1024];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] byArray = buffer.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

