/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations.mime;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.operations.mime.MimeMetadata;
import org.infinispan.rest.operations.mime.MimeMetadataBuilder;

class MimeMaxIdleExpirableMetadata
extends MimeMetadata {
    private final long maxIdleTime;
    private final TimeUnit maxIdleUnit;

    public MimeMaxIdleExpirableMetadata(String contentType, long maxIdleTime, TimeUnit maxIdleUnit) {
        super(contentType);
        this.maxIdleTime = maxIdleTime;
        this.maxIdleUnit = Objects.requireNonNull(maxIdleUnit);
    }

    @Override
    public long maxIdle() {
        return this.maxIdleUnit.toMillis(this.maxIdleTime);
    }

    @Override
    public Metadata.Builder builder() {
        return new MimeMetadataBuilder().contentType(this.contentType).maxIdle(this.maxIdleTime, this.maxIdleUnit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MimeMaxIdleExpirableMetadata that = (MimeMaxIdleExpirableMetadata)o;
        if (this.maxIdleTime != that.maxIdleTime) {
            return false;
        }
        return this.maxIdleUnit == that.maxIdleUnit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdleTime ^ this.maxIdleTime >>> 32);
        result = 31 * result + this.maxIdleUnit.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "MimeMaxIdleExpirableMetadata{maxIdleTime=" + this.maxIdleTime + ", maxIdleUnit=" + (Object)((Object)this.maxIdleUnit) + '}';
    }
}

