/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DomainServerLifecycleHandlers {
    private static final AttributeDefinition BLOCKING = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"blocking", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false))).build();
    private static final AttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timeout", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(0))).build();
    public static final String RESTART_SERVERS_NAME = "restart-servers";
    public static final String START_SERVERS_NAME = "start-servers";
    public static final String STOP_SERVERS_NAME = "stop-servers";
    public static final String SUSPEND_SERVERS_NAME = "suspend-servers";
    public static final String RESUME_SERVERS_NAME = "resume-servers";

    public static void initializeServerInventory(ServerInventory serverInventory) {
        StopServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        StartServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        RestartServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        ReloadServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        SuspendServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        ResumeServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
    }

    public static void registerDomainHandlers(ManagementResourceRegistration registration) {
        DomainServerLifecycleHandlers.registerHandlers(registration, false);
    }

    public static void registerServerGroupHandlers(ManagementResourceRegistration registration) {
        DomainServerLifecycleHandlers.registerHandlers(registration, true);
    }

    private static void registerHandlers(ManagementResourceRegistration registration, boolean serverGroup) {
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getStopOperationDefinition(serverGroup, STOP_SERVERS_NAME), (OperationStepHandler)StopServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, START_SERVERS_NAME), (OperationStepHandler)StartServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, RESTART_SERVERS_NAME), (OperationStepHandler)RestartServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, "reload-servers"), (OperationStepHandler)ReloadServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getSuspendOperationDefinition(serverGroup, SUSPEND_SERVERS_NAME), (OperationStepHandler)SuspendServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getSuspendOperationDefinition(serverGroup, RESUME_SERVERS_NAME), (OperationStepHandler)ResumeServersLifecycleHandler.INSTANCE);
    }

    private static OperationDefinition getOperationDefinition(boolean serverGroup, String operationName) {
        return new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).addParameter(BLOCKING).setRuntimeOnly().build();
    }

    private static OperationDefinition getStopOperationDefinition(boolean serverGroup, String operationName) {
        return new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).addParameter(BLOCKING).addParameter(TIMEOUT).setRuntimeOnly().build();
    }

    private static OperationDefinition getSuspendOperationDefinition(boolean serverGroup, String operationName) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).setRuntimeOnly();
        if (operationName.equals(SUSPEND_SERVERS_NAME)) {
            builder.setParameters(new AttributeDefinition[]{TIMEOUT});
        }
        return builder.build();
    }

    public static void registerServerLifeCycleOperationsTransformers(ResourceTransformationDescriptionBuilder builder) {
        ((OperationTransformationOverrideBuilder)builder.addOperationTransformationOverride(SUSPEND_SERVERS_NAME).setReject().end().discardOperations(new String[]{RESUME_SERVERS_NAME}).addOperationTransformationOverride(STOP_SERVERS_NAME).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{TIMEOUT})).end();
    }

    private static class ResumeServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "resume-servers";
        static final ResumeServersLifecycleHandler INSTANCE = new ResumeServersLifecycleHandler();

        private ResumeServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        serverInventory.resumeServer(serverModelName);
                        waitForServers.add(serverModelName);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class SuspendServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "suspend-servers";
        static final SuspendServersLifecycleHandler INSTANCE = new SuspendServersLifecycleHandler();

        private SuspendServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        waitForServers.add(serverModelName);
                    }
                    if (timeout != 0) {
                        serverInventory.awaitServerSuspend(waitForServers, timeout);
                    } else {
                        for (String serverModelName : waitForServers) {
                            serverInventory.suspendServer(serverModelName);
                        }
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class ReloadServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "reload-servers";
        static final ReloadServersLifecycleHandler INSTANCE = new ReloadServersLifecycleHandler();

        private ReloadServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        serverInventory.reloadServer(serverModelName, false);
                        waitForServers.add(serverModelName);
                    }
                    if (blocking) {
                        serverInventory.awaitServersState(waitForServers, true);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class RestartServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "restart-servers";
        static final RestartServersLifecycleHandler INSTANCE = new RestartServersLifecycleHandler();

        private RestartServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        serverInventory.restartServer(serverModelName, timeout > 0 ? timeout * 1000 : timeout, model);
                        waitForServers.add(serverModelName);
                    }
                    if (blocking) {
                        serverInventory.awaitServersState(waitForServers, true);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class StartServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "start-servers";
        static final StartServersLifecycleHandler INSTANCE = new StartServersLifecycleHandler();

        private StartServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String hostName = (String)model.get("host").keys().iterator().next();
                    ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    if (serverConfig.isDefined()) {
                        context.getServiceRegistry(true);
                        for (Property config : serverConfig.asPropertyList()) {
                            ServerStatus status = serverInventory.determineServerStatus(config.getName());
                            if (status == ServerStatus.STARTING || status == ServerStatus.STARTED || group != null && !serversInGroup.contains(config.getName())) continue;
                            if (status != ServerStatus.STOPPED) {
                                serverInventory.stopServer(config.getName(), 0);
                            }
                            serverInventory.startServer(config.getName(), model);
                            waitForServers.add(config.getName());
                        }
                        if (blocking) {
                            serverInventory.awaitServersState(waitForServers, true);
                        }
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class StopServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "stop-servers";
        static final StopServersLifecycleHandler INSTANCE = new StopServersLifecycleHandler();

        private StopServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    if (group != null) {
                        HashSet<String> waitForServers = new HashSet<String>();
                        ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
                        for (String server : this.getServersForGroup(model, group)) {
                            serverInventory.stopServer(server, timeout);
                            waitForServers.add(server);
                        }
                        if (blocking) {
                            serverInventory.awaitServersState(waitForServers, false);
                        }
                    } else {
                        serverInventory.stopServers(timeout, blocking);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static abstract class AbstractHackLifecycleHandler
    implements OperationStepHandler {
        volatile ServerInventory serverInventory;

        protected AbstractHackLifecycleHandler() {
        }

        void setServerInventory(ServerInventory serverInventory) {
            this.serverInventory = serverInventory;
        }

        String getServerGroupName(ModelNode operation) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (address.size() == 0) {
                return null;
            }
            return address.getLastElement().getValue();
        }

        Set<String> getServersForGroup(ModelNode model, String groupName) {
            if (groupName == null) {
                return Collections.emptySet();
            }
            String hostName = (String)model.get("host").keys().iterator().next();
            ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
            if (!serverConfig.isDefined()) {
                return Collections.emptySet();
            }
            HashSet<String> servers = new HashSet<String>();
            for (Property config : serverConfig.asPropertyList()) {
                if (!groupName.equals(config.getValue().get("group").asString())) continue;
                servers.add(config.getName());
            }
            return servers;
        }
    }
}

