/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.PlatformDependent;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.AbstractEncoder1x;
import org.infinispan.server.hotrod.AbstractTopologyAwareEncoder1x;
import org.infinispan.server.hotrod.Constants;
import org.infinispan.server.hotrod.Encoder2x;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.Events;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.Log;

@ChannelHandler.Sharable
class HotRodEncoder
extends MessageToByteEncoder<Object> {
    private static final Log log = (Log)LogFactory.getLog(HotRodEncoder.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final EmbeddedCacheManager cacheManager;
    private final HotRodServer server;
    private final boolean isClustered;
    private Cache<Address, ServerAddress> addressCache;

    HotRodEncoder(EmbeddedCacheManager cacheManager, HotRodServer server) {
        super(PlatformDependent.directBufferPreferred());
        this.cacheManager = cacheManager;
        this.server = server;
        this.isClustered = cacheManager.getCacheManagerConfiguration().transport().transport() != null;
    }

    private Cache<Address, ServerAddress> getAddressCache() {
        if (this.addressCache == null) {
            this.addressCache = this.isClustered ? this.cacheManager.getCache(((HotRodServerConfiguration)this.server.getConfiguration()).topologyCacheName()) : null;
        }
        return this.addressCache;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf buf) throws Exception {
        try {
            if (isTrace) {
                log.tracef("Encode msg %s", msg);
            }
            if (msg instanceof Response) {
                Response r = (Response)msg;
                VersionedEncoder encoder = this.getEncoder(r.version);
                try {
                    if (Constants.isVersionKnown(r.version)) {
                        encoder.writeHeader(r, buf, this.getAddressCache(), this.server);
                    } else {
                        encoder.writeHeader(r, buf, null, this.server);
                    }
                    encoder.writeResponse(r, buf, this.cacheManager, this.server);
                }
                catch (Throwable t) {
                    log.errorWritingResponse(r.messageId, t);
                    buf.clear();
                    ErrorResponse error = new ErrorResponse(r.version, r.messageId, r.cacheName, r.clientIntel, OperationStatus.ServerError, r.topologyId, t.toString());
                    encoder.writeHeader(error, buf, this.getAddressCache(), this.server);
                    encoder.writeResponse(error, buf, this.cacheManager, this.server);
                }
            } else if (msg instanceof Events.Event) {
                Events.Event e = (Events.Event)msg;
                VersionedEncoder encoder = this.getEncoder(e.version);
                encoder.writeEvent(e, buf);
            } else if (msg != null) {
                log.errorUnexpectedMessage(msg);
            }
        }
        catch (Throwable t) {
            log.errorEncodingMessage(msg, t);
            throw t;
        }
    }

    private VersionedEncoder getEncoder(byte version) {
        if (Constants.isVersion2x(version)) {
            return new Encoder2x();
        }
        if (Constants.isVersion10(version)) {
            return new AbstractEncoder1x(){};
        }
        if (Constants.isVersion1x(version)) {
            return new AbstractTopologyAwareEncoder1x(){};
        }
        return new Encoder2x();
    }
}

