/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.iteration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.iteration.MarshallerBuilder;

public class IterationFilter<K, V, C>
extends AbstractKeyValueFilterConverter<K, V, C> {
    final boolean compat;
    final Optional<KeyValueFilterConverter<K, V, C>> providedFilter;
    final Optional<Marshaller> marshaller;
    final boolean binary;
    protected Marshaller filterMarshaller;

    public IterationFilter(boolean compat, Optional<KeyValueFilterConverter<K, V, C>> providedFilter, Optional<Marshaller> marshaller, boolean binary) {
        this.compat = compat;
        this.providedFilter = providedFilter;
        this.marshaller = marshaller;
        this.binary = binary;
    }

    public C filterAndConvert(K key, V value, Metadata metadata) {
        if (this.providedFilter.isPresent()) {
            KeyValueFilterConverter<K, V, C> f = this.providedFilter.get();
            if (!this.compat && !this.binary) {
                try {
                    Object unmarshalledKey = this.filterMarshaller.objectFromByteBuffer((byte[])key);
                    Object unmarshalledValue = this.filterMarshaller.objectFromByteBuffer((byte[])value);
                    Object result = f.filterAndConvert(unmarshalledKey, unmarshalledValue, metadata);
                    if (result != null) {
                        return (C)this.filterMarshaller.objectToByteBuffer(result);
                    }
                    return null;
                }
                catch (IOException | ClassNotFoundException | InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
            }
            return (C)f.filterAndConvert(key, value, metadata);
        }
        return (C)value;
    }

    @Inject
    public void injectDependencies(Cache cache) {
        this.filterMarshaller = this.compat ? cache.getCacheConfiguration().compatibility().marshaller() : this.marshaller.orElse(MarshallerBuilder.genericFromInstance(this.providedFilter));
        this.providedFilter.ifPresent(kvfc -> cache.getAdvancedCache().getComponentRegistry().wireDependencies(kvfc));
    }

    public static class IterationFilterExternalizer
    extends AbstractExternalizer<IterationFilter> {
        public Set<Class<? extends IterationFilter>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{IterationFilter.class});
        }

        public void writeObject(ObjectOutput output, IterationFilter object) throws IOException {
            output.writeBoolean(object.compat);
            output.writeBoolean(object.binary);
            if (object.providedFilter.isPresent()) {
                output.writeBoolean(true);
                output.writeObject(object.providedFilter.get());
            } else {
                output.writeBoolean(false);
            }
            Class<?> marshallerClass = MarshallerBuilder.toClass(object);
            if (marshallerClass != null) {
                output.writeBoolean(true);
                output.writeObject(marshallerClass);
            } else {
                output.writeBoolean(false);
            }
        }

        public IterationFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean compat = input.readBoolean();
            boolean binary = input.readBoolean();
            Optional<Object> filter = input.readBoolean() ? Optional.of((KeyValueFilterConverter)input.readObject()) : Optional.empty();
            Optional<Class<Marshaller>> marshallerClass = input.readBoolean() ? Optional.of((Class)input.readObject()) : Optional.empty();
            return new IterationFilter(compat, filter, Optional.ofNullable(MarshallerBuilder.fromClass(marshallerClass, filter)), binary);
        }
    }
}

