/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.tx.TransactionDecodeContext;
import org.infinispan.server.hotrod.tx.TxState;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;

public class PrepareTransactionDecodeContext
extends TransactionDecodeContext {
    private final TransactionFactory transactionFactory;
    private EmbeddedTransaction tx;
    private LocalTxInvocationContext localTxInvocationContext;

    public PrepareTransactionDecodeContext(AdvancedCache<byte[], byte[]> cache, XidImpl xid) {
        super(cache, xid);
        this.transactionFactory = (TransactionFactory)cache.getComponentRegistry().getComponent(TransactionFactory.class);
    }

    public boolean startTransaction() {
        EmbeddedTransaction tx = new EmbeddedTransaction((EmbeddedBaseTransactionManager)EmbeddedTransactionManager.getInstance());
        tx.setXid((Xid)this.xid);
        LocalTransaction localTransaction = this.transactionTable.getOrCreateLocalTransaction((Transaction)tx, false, this::newGlobalTransaction);
        TxState txState = new TxState(localTransaction.getGlobalTransaction());
        if (!this.serverTransactionTable.addGlobalState(this.xid, txState)) {
            this.transactionTable.removeLocalTransaction(localTransaction);
            return false;
        }
        this.txState = txState;
        this.tx = tx;
        this.localTxInvocationContext = new LocalTxInvocationContext(localTransaction);
        this.serverTransactionTable.createLocalTx((Xid)this.xid, tx);
        this.transactionTable.enlist((Transaction)tx, localTransaction);
        return true;
    }

    public int rollback() {
        this.advance(this.txState.rollback());
        try {
            this.tx.runCommit(true);
        }
        catch (HeuristicMixedException e) {
            return 5;
        }
        catch (HeuristicRollbackException e) {
            return 6;
        }
        catch (RollbackException e) {
            return 100;
        }
        return 100;
    }

    public int prepare(boolean onePhaseCommit) {
        if (this.tx.runPrepare()) {
            this.prepared();
            if (onePhaseCommit) {
                return this.commit();
            }
            return 0;
        }
        return this.rollback();
    }

    public void setRollbackOnly() {
        try {
            this.tx.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public <K, V> AdvancedCache<K, V> decorateCache(AdvancedCache<K, V> cache) {
        if (cache instanceof EncoderCache && ((EncoderCache)cache).getDelegate() instanceof CacheImpl) {
            return this.decorateEncoderCache((EncoderCache)cache);
        }
        if (cache instanceof CacheImpl) {
            return this.withTransaction((CacheImpl)cache);
        }
        throw new IllegalArgumentException("Unable to decorate cache");
    }

    private <K, V> AdvancedCache<K, V> decorateEncoderCache(EncoderCache<K, V> cache) {
        AdvancedCache<K, V> txCache = this.withTransaction((CacheImpl)cache.getDelegate());
        return cache.withCache(txCache);
    }

    private <K, V> AdvancedCache<K, V> withTransaction(CacheImpl<K, V> cache) {
        return new DecoratedCache<K, V>((AdvancedCache)cache, new Flag[]{Flag.FORCE_WRITE_LOCK}){

            protected InvocationContext readContext(int size) {
                return PrepareTransactionDecodeContext.this.localTxInvocationContext;
            }

            protected InvocationContext writeContext(int size) {
                return PrepareTransactionDecodeContext.this.localTxInvocationContext;
            }
        };
    }

    private int commit() {
        this.advance(this.txState.commit());
        try {
            this.tx.runCommit(false);
        }
        catch (HeuristicMixedException e) {
            return 5;
        }
        catch (HeuristicRollbackException e) {
            return 6;
        }
        catch (RollbackException e) {
            return 100;
        }
        return 0;
    }

    private void prepared() {
        List modifications = this.transactionTable.getLocalTransaction((Transaction)this.tx).getModifications();
        this.advance(this.txState.prepare(modifications));
    }

    private GlobalTransaction newGlobalTransaction() {
        return this.transactionFactory.newGlobalTransaction((Address)this.serverTransactionTable.getClientAddress(), false);
    }
}

