/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.SubjectUserInfo;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.RealmSubjectUserInfo;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;

public class EndpointServerAuthenticationProvider
implements ServerAuthenticationProvider {
    static final String SASL_OPT_REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    static final String SASL_OPT_ALT_PROTO_PROPERTY = "org.jboss.sasl.digest.alternative_protocols";
    static final String SASL_OPT_PRE_DIGESTED_PROPERTY = "org.jboss.sasl.digest.pre_digested";
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String EXTERNAL = "EXTERNAL";
    static final String GSSAPI = "GSSAPI";
    static final String PLAIN = "PLAIN";
    private final SecurityRealm realm;

    EndpointServerAuthenticationProvider(SecurityRealm realm) {
        this.realm = realm;
    }

    public org.infinispan.server.core.security.AuthorizingCallbackHandler getCallbackHandler(String mechanismName, Map<String, String> mechanismProperties) {
        if (GSSAPI.equals(mechanismName)) {
            return new GSSAPIEndpointAuthorizingCallbackHandler();
        }
        if (PLAIN.equals(mechanismName)) {
            return new RealmAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        }
        if (DIGEST_MD5.equals(mechanismName)) {
            if (!mechanismProperties.containsKey(SASL_OPT_REALM_PROPERTY)) {
                mechanismProperties.put(SASL_OPT_REALM_PROPERTY, this.realm.getName());
            }
            Map mechConfig = this.realm.getMechanismConfig(AuthMechanism.DIGEST);
            boolean plainTextDigest = true;
            if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
                plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
            }
            if (!plainTextDigest) {
                mechanismProperties.put(SASL_OPT_PRE_DIGESTED_PROPERTY, "true");
            }
            return new RealmAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST));
        }
        if (EXTERNAL.equals(mechanismName)) {
            return new RealmAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT));
        }
        throw new IllegalArgumentException("Unsupported mech " + mechanismName);
    }

    public class RealmAuthorizingCallbackHandler
    implements org.infinispan.server.core.security.AuthorizingCallbackHandler {
        private final AuthorizingCallbackHandler delegate;

        public RealmAuthorizingCallbackHandler(AuthorizingCallbackHandler authorizingCallbackHandler) {
            this.delegate = authorizingCallbackHandler;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            this.delegate.handle(callbacks);
        }

        public SubjectUserInfo getSubjectUserInfo(Collection<Principal> principals) {
            try {
                org.jboss.as.core.security.SubjectUserInfo realmUserInfo = this.delegate.createSubjectUserInfo(principals);
                return new RealmSubjectUserInfo(realmUserInfo.getUserName(), realmUserInfo.getSubject());
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public class GSSAPIEndpointAuthorizingCallbackHandler
    implements org.infinispan.server.core.security.AuthorizingCallbackHandler {
        private final AuthorizingCallbackHandler delegate;
        private RealmUser realmUser;

        GSSAPIEndpointAuthorizingCallbackHandler() {
            this.delegate = EndpointServerAuthenticationProvider.this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN);
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
            String authenticationId = acb.getAuthenticationID();
            String authorizationId = acb.getAuthorizationID();
            acb.setAuthorized(authenticationId.equals(authorizationId));
            int realmSep = authorizationId.indexOf(64);
            this.realmUser = realmSep <= 0 ? new RealmUser(authorizationId) : new RealmUser(authorizationId.substring(realmSep + 1), authorizationId.substring(0, realmSep));
        }

        public SubjectUserInfo getSubjectUserInfo(Collection<Principal> principals) {
            ArrayList<RealmUser> realmPrincipals = new ArrayList<RealmUser>();
            realmPrincipals.add(this.realmUser);
            try {
                org.jboss.as.core.security.SubjectUserInfo userInfo = this.delegate.createSubjectUserInfo(realmPrincipals);
                userInfo.getPrincipals().addAll(principals);
                return new RealmSubjectUserInfo(userInfo);
            }
            catch (IOException e) {
                throw EndpointLogger.ROOT_LOGGER.cannotRetrieveAuthorizationInformation(e, this.realmUser.toString());
            }
        }
    }
}

