/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;

public class CompatModeEncoder
implements Encoder {
    protected final Marshaller marshaller;

    public CompatModeEncoder(Marshaller marshaller) {
        this.marshaller = marshaller == null ? new GenericJBossMarshaller() : marshaller;
    }

    @Override
    public Object toStorage(Object content) {
        if (content instanceof byte[]) {
            try {
                return this.unmarshall((byte[])content);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        return content;
    }

    @Override
    public Object fromStorage(Object content) {
        try {
            return this.marshall(content);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public boolean isStorageFormatFilterable() {
        return true;
    }

    @Override
    public MediaType getStorageFormat() {
        return MediaType.APPLICATION_OBJECT;
    }

    @Override
    public short id() {
        return 7;
    }

    protected Object unmarshall(byte[] source) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(source);
    }

    protected Object marshall(Object source) throws Exception {
        return this.marshaller.objectToByteBuffer(source);
    }
}

