/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class ReadWriteKeyCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 50;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;

    public ReadWriteKeyCommand(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(key, valueMatcher, id, params, keyDataConversion, valueDataConversion);
        this.f = f;
        this.init(componentRegistry);
    }

    public ReadWriteKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 50;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        Params.writeObject(output, this.params);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.keyDataConversion);
        output.writeObject(this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Function)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keyDataConversion = (DataConversion)input.readObject();
        this.valueDataConversion = (DataConversion)input.readObject();
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        EntryView.ReadWriteEntryView entry = EntryViews.readWrite(e, this.keyDataConversion, this.valueDataConversion);
        R ret = this.f.apply(entry);
        return EntryViews.snapshot(ret);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public Mutation<K, V, ?> toMutation(K key) {
        return new Mutations.ReadWrite<K, V, R>(this.f);
    }

    public Function<EntryView.ReadWriteEntryView<K, V>, R> getFunction() {
        return this.f;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteKeyCommand{");
        sb.append(", key=").append(Util.toStr((Object)this.key));
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", flags=").append(this.printFlags());
        sb.append(", commandInvocationId=").append(this.commandInvocationId);
        sb.append(", params=").append(this.params);
        sb.append(", valueMatcher=").append((Object)this.valueMatcher);
        sb.append(", successful=").append(this.successful);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }
}

